/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.impl;

import agent.dbgeng.manager.DbgStackFrame;
import agent.dbgeng.manager.cmd.DbgConsoleExecCommand;
import agent.dbgeng.manager.cmd.DbgEvaluateCommand;
import agent.dbgeng.manager.cmd.DbgReadRegistersCommand;
import agent.dbgeng.manager.cmd.DbgWriteRegistersCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgRegister;
import agent.dbgeng.manager.impl.DbgThreadImpl;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.seq.AsyncSequenceHandlerForRunner;
import java.math.BigInteger;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class DbgStackFrameImpl
implements DbgStackFrame {
    protected final DbgManagerImpl manager;
    protected final DbgThreadImpl thread;
    protected final int level;
    protected final BigInteger addr;
    protected final String func;
    private long funcTableEntry;
    private long frameOffset;
    private long returnOffset;
    private long stackOffset;
    private boolean virtual;
    private long[] params = new long[4];

    public DbgStackFrameImpl(DbgThreadImpl thread, int level, BigInteger addr, String func) {
        this.manager = thread.manager;
        this.thread = thread;
        this.level = level;
        this.addr = addr;
        this.func = func;
    }

    public DbgStackFrameImpl(DbgThreadImpl thread, int level, BigInteger addr, long funcTableEntry, long frameOffset, long returnOffset, long stackOffset, boolean virtual, long param0, long param1, long param2, long param3) {
        this.manager = thread.manager;
        this.thread = thread;
        this.level = level;
        this.addr = addr;
        this.func = null;
        this.funcTableEntry = funcTableEntry;
        this.frameOffset = frameOffset;
        this.returnOffset = returnOffset;
        this.stackOffset = stackOffset;
        this.virtual = virtual;
        this.params[0] = param0;
        this.params[1] = param1;
        this.params[2] = param2;
        this.params[3] = param3;
    }

    public String toString() {
        return "<DbgStackFrame: level=" + this.level + ",addr=0x" + this.addr.toString(16) + ",func='" + this.func + "'>";
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public BigInteger getAddress() {
        return this.addr;
    }

    @Override
    public String getFunction() {
        return this.func;
    }

    @Override
    public DbgThreadImpl getThread() {
        return this.thread;
    }

    @Override
    public long getFuncTableEntry() {
        return this.funcTableEntry;
    }

    @Override
    public long getFrameOffset() {
        return this.frameOffset;
    }

    @Override
    public long getReturnOffset() {
        return this.returnOffset;
    }

    @Override
    public long getStackOffset() {
        return this.stackOffset;
    }

    @Override
    public boolean getVirtual() {
        return this.virtual;
    }

    @Override
    public long[] getParams() {
        return this.params;
    }

    @Override
    public CompletableFuture<Void> setActive() {
        return this.thread.setActive();
    }

    @Override
    public CompletableFuture<String> evaluate(String expression) {
        return this.manager.execute(new DbgEvaluateCommand(this.manager, expression));
    }

    @Override
    public CompletableFuture<Map<DbgRegister, BigInteger>> readRegisters(Set<DbgRegister> regs) {
        return AsyncUtils.sequence((TypeSpec)TypeSpec.map(DbgRegister.class, BigInteger.class)).then(seq -> this.manager.execute(new DbgReadRegistersCommand(this.manager, this.thread, this.level, regs)).handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).exit(arg_0, arg_1))).finish();
    }

    @Override
    public CompletableFuture<Void> writeRegisters(Map<DbgRegister, BigInteger> regVals) {
        return this.manager.execute(new DbgWriteRegistersCommand(this.manager, this.thread, this.level, regVals));
    }

    @Override
    public CompletableFuture<Void> console(String command) {
        return this.manager.execute(new DbgConsoleExecCommand(this.manager, command, DbgConsoleExecCommand.Output.CONSOLE)).thenApply(e -> null);
    }

    @Override
    public CompletableFuture<String> consoleCapture(String command) {
        return this.manager.execute(new DbgConsoleExecCommand(this.manager, command, DbgConsoleExecCommand.Output.CAPTURE));
    }
}

