/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgProcess;
import agent.dbgeng.manager.breakpoint.DbgBreakpointInfo;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.model.iface2.DbgModelTargetBreakpointContainer;
import agent.dbgeng.model.iface2.DbgModelTargetBreakpointSpec;
import agent.dbgeng.model.iface2.DbgModelTargetDebugContainer;
import agent.dbgeng.model.iface2.DbgModelTargetProcess;
import agent.dbgeng.model.iface2.DbgModelTargetThread;
import agent.dbgeng.model.impl.DbgModelImpl;
import agent.dbgeng.model.impl.DbgModelTargetBreakpointSpecImpl;
import agent.dbgeng.model.impl.DbgModelTargetObjectImpl;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="BreakpointContainer", elements={@TargetElementType(type=DbgModelTargetBreakpointSpecImpl.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class DbgModelTargetBreakpointContainerImpl
extends DbgModelTargetObjectImpl
implements DbgModelTargetBreakpointContainer {
    protected static final TargetBreakpointSpecContainer.TargetBreakpointKindSet SUPPORTED_KINDS = TargetBreakpointSpecContainer.TargetBreakpointKindSet.of((TargetBreakpointSpec.TargetBreakpointKind[])TargetBreakpointSpec.TargetBreakpointKind.values());

    public DbgModelTargetBreakpointContainerImpl(DbgModelTargetDebugContainer debug) {
        super(debug.getModel(), (TargetObject)debug, "Breakpoints", "BreakpointContainer");
        this.getManager().addEventsListener(this);
        this.changeAttributes(List.of(), List.of(), Map.of("_supported_breakpoint_kinds", SUPPORTED_KINDS), "Initialized");
    }

    private boolean isMatch(DbgBreakpointInfo info) {
        DbgProcess bptProc = info.getProc();
        DbgModelTargetProcess parentProcess = this.getParentProcess();
        return parentProcess.getProcess().equals(bptProc);
    }

    @Override
    public void breakpointCreated(DbgBreakpointInfo info, DbgCause cause) {
        if (!this.isMatch(info)) {
            return;
        }
        this.changeElements(List.of(), List.of(this.getTargetBreakpointSpec(info)), Map.of(), "Created");
    }

    @Override
    public void breakpointModified(DbgBreakpointInfo newInfo, DbgBreakpointInfo oldInfo, DbgCause cause) {
        if (!this.isMatch(newInfo)) {
            return;
        }
        this.getTargetBreakpointSpec(oldInfo).updateInfo(oldInfo, newInfo, "Modified");
    }

    @Override
    public void breakpointDeleted(DbgBreakpointInfo info, DbgCause cause) {
        if (!this.isMatch(info)) {
            return;
        }
        DbgModelImpl impl = (DbgModelImpl)this.model;
        impl.deleteModelObject(info.getDebugBreakpoint());
        this.changeElements(List.of(DbgModelTargetBreakpointSpecImpl.indexBreakpoint(info)), List.of(), Map.of(), "Deleted");
    }

    @Override
    public void breakpointHit(DbgBreakpointInfo info, DbgCause cause) {
        DbgModelTargetThread targetThread = this.getParentProcess().getThreads().getTargetThread(this.getManager().getEventThread());
        DbgModelTargetBreakpointSpec spec = this.getTargetBreakpointSpec(info);
        this.broadcast().breakpointHit((TargetObject)this.getProxy(), (TargetObject)targetThread, null, (TargetBreakpointSpec)spec, (TargetBreakpointLocation)spec);
        spec.breakpointHit();
    }

    public DbgModelTargetBreakpointSpec getTargetBreakpointSpec(DbgBreakpointInfo info) {
        DbgModelImpl impl = (DbgModelImpl)this.model;
        TargetObject modelObject = impl.getModelObject(info.getDebugBreakpoint());
        if (modelObject != null) {
            return (DbgModelTargetBreakpointSpec)modelObject;
        }
        return new DbgModelTargetBreakpointSpecImpl(this, info);
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        DbgManagerImpl manager = this.getManager();
        return manager.listBreakpoints().thenAccept(byNumber -> {
            List specs;
            DbgModelTargetBreakpointContainerImpl dbgModelTargetBreakpointContainerImpl = this;
            synchronized (dbgModelTargetBreakpointContainerImpl) {
                specs = byNumber.values().stream().map(this::getTargetBreakpointSpec).collect(Collectors.toList());
            }
            this.setElements(specs, Map.of(), "Refreshed");
        });
    }
}

