/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.ModuleInformation500;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbDebugInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.util.exception.CancelledException;
import java.io.IOException;
import java.io.Writer;

public class PdbOldDebugInfo
extends PdbDebugInfo {
    private static final int OLD_DBI_HEADER_LENGTH = 22;

    public PdbOldDebugInfo(AbstractPdb pdb, int streamNumber) {
        super(pdb, streamNumber);
    }

    @Override
    protected void deserializeHeader(PdbByteReader reader) throws PdbException {
        this.streamNumberGlobalStaticSymbolsHashMaybe = reader.parseUnsignedShortVal();
        this.streamNumberPublicStaticSymbolsHashMaybe = reader.parseUnsignedShortVal();
        this.streamNumberSymbolRecords = reader.parseUnsignedShortVal();
        this.lengthModuleInformationSubstream = reader.parseInt();
        this.lengthSectionContributionSubstream = reader.parseInt();
        this.lengthSectionMap = reader.parseInt();
        this.lengthFileInformation = reader.parseInt();
    }

    @Override
    protected int getHeaderLength() {
        return 22;
    }

    @Override
    protected void deserializeInternalSubstreams(PdbByteReader reader) throws PdbException, CancelledException {
        this.processModuleInformation(reader, false);
        this.processSectionContributions(reader, false);
        this.processSegmentMap(reader, false);
        this.processFileInformation(reader, false);
    }

    @Override
    protected void initializeAdditionalComponentsForSubstreams() throws IOException, PdbException, CancelledException {
        this.symbolRecords.initialize();
        this.globalSymbolInformation.initialize();
        this.publicSymbolInformation.initialize();
    }

    @Override
    protected void processModuleInformation(PdbByteReader reader, boolean skip) throws PdbException, CancelledException {
        if (this.lengthModuleInformationSubstream == 0) {
            return;
        }
        if (skip) {
            reader.skip(this.lengthModuleInformationSubstream);
            return;
        }
        PdbByteReader substreamReader = reader.getSubPdbByteReader(this.lengthModuleInformationSubstream);
        while (substreamReader.hasMore()) {
            this.pdb.checkCancelled();
            ModuleInformation500 moduleInformation = new ModuleInformation500(this.pdb);
            moduleInformation.deserialize(substreamReader);
            this.moduleInformationList.add(moduleInformation);
        }
    }

    @Override
    protected String parseFileInfoName(PdbByteReader reader) throws PdbException {
        String filename = reader.parseString(this.pdb, StringParseType.StringSt);
        return filename;
    }

    @Override
    protected void dumpHeader(Writer writer) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("streamNumberGlobalStaticSymbols: ");
        builder.append(this.streamNumberGlobalStaticSymbolsHashMaybe);
        builder.append("\nstreamNumberPublicStaticSymbols: ");
        builder.append(this.streamNumberPublicStaticSymbolsHashMaybe);
        builder.append("\nstreamNumberSymbolRecords: ");
        builder.append(this.streamNumberSymbolRecords);
        builder.append("\nlengthModuleInformationSubstream: ");
        builder.append(this.lengthModuleInformationSubstream);
        builder.append("\nlengthSectionContributionSubstream: ");
        builder.append(this.lengthSectionContributionSubstream);
        builder.append("\nlengthSectionMap: ");
        builder.append(this.lengthSectionMap);
        builder.append("\nlengthFileInformation: ");
        builder.append(this.lengthFileInformation);
        writer.write(builder.toString());
    }

    @Override
    protected void dumpInternalSubstreams(Writer writer) throws IOException, CancelledException {
        writer.write("ModuleInformationList---------------------------------------\n");
        this.dumpModuleInformation(writer);
        writer.write("\nEnd ModuleInformationList-----------------------------------\n");
        writer.write("SectionContributionList-------------------------------------\n");
        this.dumpSectionContributions(writer);
        writer.write("\nEnd SectionContributionList---------------------------------\n");
        writer.write("SegmentMap--------------------------------------------------\n");
        this.dumpSegmentMap(writer);
        writer.write("\nEnd SegmentMap----------------------------------------------\n");
    }
}

