/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractComplexMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MsProperty;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.PrimitiveMsType;
import java.math.BigInteger;

public abstract class AbstractCompositeMsType
extends AbstractComplexMsType {
    protected RecordNumber derivedFromListRecordNumber;
    protected RecordNumber vShapeTableRecordNumber;
    protected BigInteger size;
    protected String mangledName;

    public AbstractCompositeMsType(AbstractPdb pdb, PdbByteReader reader) {
        super(pdb, reader);
    }

    public AbstractCompositeMsType(AbstractPdb pdb, int count, RecordNumber fieldListRecordNumber, MsProperty property, long size, RecordNumber derivedFromRecordNumber, RecordNumber vShapeTableRecordNumber, String name, String mangledName) {
        super(pdb, null);
        this.name = name;
        this.mangledName = mangledName;
        this.size = BigInteger.valueOf(size);
        this.property = property;
        this.fieldDescriptorListRecordNumber = fieldListRecordNumber;
        this.derivedFromListRecordNumber = derivedFromRecordNumber;
        this.vShapeTableRecordNumber = vShapeTableRecordNumber;
    }

    public String getMangledName() {
        return this.mangledName;
    }

    public RecordNumber getDerivedFromListRecordNumber() {
        return this.derivedFromListRecordNumber;
    }

    public RecordNumber getVShapeTableRecordNumber() {
        return this.vShapeTableRecordNumber;
    }

    @Override
    public BigInteger getSize() {
        return this.size;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        StringBuilder myBuilder = new StringBuilder();
        myBuilder.append(this.getTypeString());
        myBuilder.append(" ");
        myBuilder.append(this.name);
        myBuilder.append("<");
        if (this.count != -1) {
            myBuilder.append(this.count);
            myBuilder.append(",");
        }
        myBuilder.append(this.property);
        myBuilder.append(">");
        AbstractMsType fieldType = this.getFieldDescriptorListType();
        if (fieldType instanceof PrimitiveMsType && ((PrimitiveMsType)fieldType).isNoType()) {
            myBuilder.append("{}");
        } else {
            myBuilder.append(fieldType);
        }
        myBuilder.append(" ");
        builder.insert(0, myBuilder);
    }
}

