/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractArrayMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.FixupContext;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Undefined1DataType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import java.math.BigInteger;

public class ArrayTypeApplier
extends MsTypeApplier {
    public ArrayTypeApplier(DefaultPdbApplicator applicator) {
        super(applicator);
    }

    @Override
    DataType apply(AbstractMsType type, FixupContext fixupContext, boolean breakCycle) throws PdbException, CancelledException {
        return this.applyType((AbstractArrayMsType)type, fixupContext);
    }

    boolean isFlexibleArray(AbstractMsType type) {
        return BigInteger.ZERO.equals(type.getSize());
    }

    private DataType applyType(AbstractArrayMsType type, FixupContext fixupContext) throws CancelledException, PdbException {
        DataType dataType;
        DataType existingDt;
        if (fixupContext != null && (existingDt = this.applicator.getDataType(type)) != null) {
            return existingDt;
        }
        RecordNumber underlyingRecord = type.getElementTypeRecordNumber();
        DataType underlyingDataType = this.applicator.getProcessedDataType(underlyingRecord, fixupContext, false);
        if (this.applicator.isPlaceholderType(underlyingDataType)) {
            Long longArraySize = this.getSizeLong(type);
            int intArraySize = longArraySize.intValue();
            dataType = this.applicator.getPlaceholderArray(intArraySize, underlyingDataType.getAlignment());
        } else {
            int numElements = this.calculateNumElements(type, underlyingDataType);
            if (numElements == -1) {
                underlyingDataType = Undefined1DataType.dataType;
                numElements = this.getSizeInt(type);
            }
            dataType = new ArrayDataType(underlyingDataType, numElements, -1, this.applicator.getDataTypeManager());
        }
        DataType resolvedType = this.applicator.resolve(dataType);
        this.applicator.putDataType(type, resolvedType);
        return resolvedType;
    }

    private int calculateNumElements(AbstractArrayMsType type, DataType underlyingDataType) {
        long longUnderlyingSize;
        if (underlyingDataType == null) {
            underlyingDataType = Undefined1DataType.dataType;
            String msg = "PDB Type index " + type.getRecordNumber().getNumber() + ":\n   Null underlying data type for " + type.getClass().getSimpleName() + ":\n      " + type.getName() + "\n   Using " + underlyingDataType;
            Msg.warn((Object)this, (Object)msg);
        }
        if ((longUnderlyingSize = (long)underlyingDataType.getLength()) > Integer.MAX_VALUE) {
            String msg = "PDB " + type.getClass().getSimpleName() + ": Underlying type too large " + underlyingDataType.getName();
            Msg.warn((Object)this, (Object)msg);
            underlyingDataType = Undefined1DataType.dataType;
            longUnderlyingSize = 1L;
        } else if (longUnderlyingSize == 0L) {
            longUnderlyingSize = 1L;
        }
        long longArraySize = this.getSizeLong(type);
        long longNumElements = longArraySize / longUnderlyingSize;
        if (longNumElements > Integer.MAX_VALUE) {
            String msg = "PDB " + type.getClass().getSimpleName() + ": Array num elements too large: " + longUnderlyingSize;
            Msg.warn((Object)this, (Object)msg);
            longNumElements = 1L;
        } else if (longArraySize == 0L) {
            longNumElements = 0L;
        } else if (longArraySize % longUnderlyingSize != 0L) {
            String msg = "PDB " + type.getClass().getSimpleName() + ": Array num elements calculation error underlying type " + longArraySize + " % " + longUnderlyingSize;
            Msg.warn((Object)this, (Object)msg);
            return -1;
        }
        int numElements = (int)longNumElements;
        return numElements;
    }
}

