/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.bin.format.pdb2.pdbreader.Numeric;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractComplexMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractEnumMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractEnumerateMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.pdb.pdbapplicator.AbstractComplexTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.FieldListTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.FixupContext;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.EnumDataType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import java.util.List;

public class EnumTypeApplier
extends AbstractComplexTypeApplier {
    public EnumTypeApplier(DefaultPdbApplicator applicator) {
        super(applicator);
    }

    private long getMask(AbstractEnumMsType type, FixupContext fixupContext, boolean breakCycle) throws CancelledException, PdbException {
        switch (this.getLength(type, fixupContext, breakCycle)) {
            case 1: {
                return 255L;
            }
            case 2: {
                return 65535L;
            }
            case 4: {
                return 0xFFFFFFFFL;
            }
        }
        return -1L;
    }

    private int getLength(AbstractEnumMsType type, FixupContext fixupContext, boolean breakCycle) throws CancelledException, PdbException {
        DataType underlyingDataType = this.getUnderlyingDataType(type, fixupContext, breakCycle);
        if (underlyingDataType == null) {
            return 1;
        }
        return Integer.max(underlyingDataType.getLength(), 1);
    }

    private DataType getUnderlyingDataType(AbstractEnumMsType type, FixupContext fixupContext, boolean breakCycle) throws CancelledException, PdbException {
        RecordNumber underlyingRecordNumber = type.getUnderlyingRecordNumber();
        return this.applicator.getProcessedDataType(underlyingRecordNumber, fixupContext, breakCycle);
    }

    boolean isSigned(AbstractEnumMsType type, FixupContext fixupContext, boolean breakCycle) throws CancelledException, PdbException {
        DataType underlyingType = this.getUnderlyingDataType(type, fixupContext, breakCycle);
        if (underlyingType == null) {
            return false;
        }
        if (underlyingType instanceof AbstractIntegerDataType) {
            return ((AbstractIntegerDataType)underlyingType).isSigned();
        }
        return false;
    }

    private EnumDataType createEmptyEnum(AbstractEnumMsType type, FixupContext fixupContext, boolean breakCycle) throws CancelledException, PdbException {
        AbstractEnumMsType defType = this.getDefinitionType(type);
        SymbolPath fixedPath = this.getFixedSymbolPath(defType);
        CategoryPath categoryPath = this.applicator.getCategory(fixedPath.getParent());
        EnumDataType enumDataType = new EnumDataType(categoryPath, fixedPath.getName(), this.getLength(defType, fixupContext, breakCycle), this.applicator.getDataTypeManager());
        return enumDataType;
    }

    @Override
    DataType apply(AbstractMsType type, FixupContext fixupContext, boolean breakCycle) throws PdbException, CancelledException {
        Integer number = this.applicator.getNumber(type);
        Integer mapped = this.applicator.getMappedComplexType(number);
        AbstractEnumMsType definedEnum = (AbstractEnumMsType)this.applicator.getPdb().getTypeRecord(RecordNumber.typeRecordNumber(mapped));
        DataType existingDt = this.applicator.getDataType(mapped);
        if (existingDt != null) {
            if (!(existingDt instanceof Enum)) {
                throw new PdbException("PDB error retrieving Enum type");
            }
            return existingDt;
        }
        EnumDataType enumDataType = this.createEmptyEnum(definedEnum, fixupContext, breakCycle);
        this.applyEnumMsType(enumDataType, definedEnum, fixupContext, breakCycle);
        DataType dataType = this.applicator.resolve((DataType)enumDataType);
        this.applicator.putDataType(mapped, dataType);
        return dataType;
    }

    private EnumDataType applyEnumMsType(EnumDataType enumDataType, AbstractEnumMsType type, FixupContext fixupContext, boolean breakCycle) throws PdbException, CancelledException {
        if (enumDataType.getCount() != 0) {
            return enumDataType;
        }
        String fullPathName = type.getName();
        RecordNumber fieldListRecordNumber = type.getFieldDescriptorListRecordNumber();
        FieldListTypeApplier fieldListApplier = FieldListTypeApplier.getFieldListApplierSpecial(this.applicator, fieldListRecordNumber);
        FieldListTypeApplier.FieldLists lists = fieldListApplier.getFieldLists(fieldListRecordNumber);
        List<AbstractEnumerateMsType> enumerates = lists.enumerates();
        int numElements = type.getNumElements();
        if (enumerates.size() != numElements) {
            this.pdbLogAndInfoMessage(this, "Enum expecting " + numElements + " elements, but only " + enumerates.size() + " available for " + fullPathName);
        }
        int length = this.getLength(type, fixupContext, breakCycle);
        boolean isSigned = this.isSigned(type, fixupContext, breakCycle);
        for (AbstractEnumerateMsType enumerateType : enumerates) {
            SymbolPath memberSymbolPath = new SymbolPath(enumerateType.getName());
            enumDataType.add(memberSymbolPath.getName(), this.narrowingConversion(type, length, isSigned, enumerateType.getNumeric(), fixupContext, breakCycle));
        }
        return enumDataType;
    }

    private long narrowingConversion(AbstractEnumMsType type, int outputSize, boolean outputSigned, Numeric numeric, FixupContext fixupContext, boolean breakCycle) throws CancelledException, PdbException {
        if (!numeric.isIntegral()) {
            Msg.info((Object)this, (Object)("Non-integral numeric found: " + numeric));
            return 0L;
        }
        if (!numeric.isIntegral()) {
            this.pdbLogAndInfoMessage(this, "Using zero in place of non-integral enumerate: " + numeric);
            return 0L;
        }
        return numeric.getIntegral().longValue() & this.getMask(type, fixupContext, breakCycle);
    }

    private AbstractEnumMsType getDefinitionType(AbstractComplexMsType type) {
        return this.getDefinitionType(type, AbstractEnumMsType.class);
    }
}

