/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.program.model.data.DataType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FixupContext {
    private Deque<Integer> stagedRecordFifo = new ArrayDeque<Integer>();
    private Deque<Integer> inProgressRecordStack = new ArrayDeque<Integer>();
    private Deque<Integer> fixupRecordFifo = new ArrayDeque<Integer>();
    private Map<Integer, List<Integer>> map = new HashMap<Integer, List<Integer>>();
    private Map<Integer, DataType> fixupTypes = new HashMap<Integer, DataType>();

    void ensureInContext(int record) throws PdbException {
        if (this.inProgressRecordStack.contains(record)) {
            return;
        }
        if (this.fixupRecordFifo.contains(record)) {
            return;
        }
        this.addStagedRecord(record);
    }

    DataType getFixupDataType(int record) {
        return this.fixupTypes.get(record);
    }

    void addStagedRecord(int recordNumber) throws PdbException {
        if (this.stagedRecordFifo.contains(recordNumber)) {
            return;
        }
        if (this.inProgressRecordStack.contains(recordNumber)) {
            throw new PdbException("Record Number in process state: " + recordNumber);
        }
        if (this.fixupRecordFifo.contains(recordNumber)) {
            throw new PdbException("Record Number in fixup state: " + recordNumber);
        }
        if (this.map.containsKey(recordNumber)) {
            throw new PdbException("Record Number already exists: " + recordNumber);
        }
        this.map.put(recordNumber, new ArrayList());
        this.putStagedRecord(recordNumber);
    }

    Integer moveFromStagedToProcessRecord() throws PdbException {
        Integer record = this.getStagedRecord();
        if (record != null) {
            this.putProcessRecord(record);
        }
        return record;
    }

    void moveFromStagedToProcessRecord(int number) throws PdbException {
        if (!this.stagedRecordFifo.remove(number)) {
            throw new PdbException("Number not in Staged state: " + number);
        }
        this.putProcessRecord(number);
    }

    void moveToHeadProcessRecord(int number) throws PdbException {
        if (this.stagedRecordFifo.contains(number)) {
            this.stagedRecordFifo.remove(number);
        } else if (this.inProgressRecordStack.contains(number)) {
            this.inProgressRecordStack.remove(number);
            this.inProgressRecordStack.offerFirst(number);
        } else {
            this.map.put(number, new ArrayList());
        }
        this.putProcessRecord(number);
    }

    void moveProcessToFixupsRecord(int number, DataType dataType) throws PdbException {
        if (!this.inProgressRecordStack.remove(number)) {
            throw new PdbException("Number not in process state: " + number);
        }
        if (this.fixupTypes.containsKey(number)) {
            throw new PdbException("Number already in progress: " + number);
        }
        this.putFixupsRecord(number);
        this.fixupTypes.put(number, dataType);
    }

    Integer popFixupsRecord() {
        Integer record = this.getFixupsRecord();
        if (record != null) {
            if (this.map.containsKey(record)) {
                this.map.remove(record);
            }
            if (this.fixupTypes.containsKey(record)) {
                this.fixupTypes.remove(record);
            }
        }
        return record;
    }

    Integer popProcessRecord() {
        Integer record = this.getProcessRecord();
        if (record != null && this.map.containsKey(record)) {
            this.map.remove(record);
        }
        return record;
    }

    private void putStagedRecord(int record) throws PdbException {
        if (this.stagedRecordFifo.contains(record)) {
            return;
        }
        if (this.inProgressRecordStack.contains(record)) {
            throw new PdbException("Record exists in another state: " + record);
        }
        if (this.fixupRecordFifo.contains(record)) {
            throw new PdbException("Record exists in another state: " + record);
        }
        this.stagedRecordFifo.addFirst(record);
    }

    private Integer getStagedRecord() {
        return this.stagedRecordFifo.pollLast();
    }

    Integer peekStagedRecord() {
        return this.stagedRecordFifo.peekLast();
    }

    private void putProcessRecord(int record) throws PdbException {
        if (this.inProgressRecordStack.contains(record)) {
            return;
        }
        if (this.stagedRecordFifo.contains(record)) {
            throw new PdbException("Record exists in another state: " + record);
        }
        if (this.fixupRecordFifo.contains(record)) {
            throw new PdbException("Record exists in another state: " + record);
        }
        this.inProgressRecordStack.addFirst(record);
    }

    private Integer getProcessRecord() {
        return this.inProgressRecordStack.pollFirst();
    }

    private void putFixupsRecord(int record) throws PdbException {
        if (this.fixupRecordFifo.contains(record)) {
            return;
        }
        if (this.stagedRecordFifo.contains(record)) {
            throw new PdbException("Record exists in another state: " + record);
        }
        if (this.inProgressRecordStack.contains(record)) {
            throw new PdbException("Record exists in another state: " + record);
        }
        this.fixupRecordFifo.addFirst(record);
    }

    Integer peekProcessRecord() {
        return this.inProgressRecordStack.peekFirst();
    }

    Integer getFixupsRecord() {
        return this.fixupRecordFifo.pollLast();
    }

    Integer peekFixupsRecord() {
        return this.fixupRecordFifo.peekLast();
    }

    void putFixup(int fixupIndex) throws PdbException {
        List<Integer> fixups = this.getProcessFixups();
        fixups.add(fixupIndex);
    }

    boolean processFixupsIsEmpty() throws PdbException {
        List<Integer> fixups = this.getProcessFixups();
        return fixups.isEmpty();
    }

    Integer peekFixupRecord() {
        return this.peekFixupsRecord();
    }

    List<Integer> getFixups() throws PdbException {
        Integer record = this.peekFixupsRecord();
        if (record == null) {
            throw new PdbException("Empty fixups retrieval");
        }
        List<Integer> fixups = this.map.get(record);
        if (fixups == null) {
            throw new PdbException("Fixups not found on retrieval");
        }
        return fixups;
    }

    private List<Integer> getProcessFixups() throws PdbException {
        Integer record = this.peekProcessRecord();
        if (record == null) {
            throw new PdbException("Context empty on fixups retrieval");
        }
        List<Integer> fixups = this.map.get(record);
        if (fixups == null) {
            throw new PdbException("Fixups not found");
        }
        return fixups;
    }
}

