/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi.launcher;

import docking.ActionContext;
import docking.PopupMenuHandler;
import docking.action.DockingActionIf;
import docking.action.MultiActionDockingActionIf;
import docking.action.ToolBarData;
import docking.action.builder.ActionBuilder;
import docking.menu.MenuHandler;
import docking.menu.MenuManager;
import docking.menu.MultiActionDockingAction;
import docking.menu.MultipleActionDockingToolbarButton;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.TraceRmiLauncherServicePlugin;
import ghidra.debug.api.tracermi.TraceRmiLaunchOffer;
import ghidra.framework.options.SaveState;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramUserData;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.xml.XmlUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import org.jdom.Element;
import org.jdom.JDOMException;

public class LaunchAction
extends MultiActionDockingAction {
    public static final String NAME = "Launch";
    public static final Icon ICON = DebuggerResources.ICON_DEBUGGER;
    public static final String GROUP = "Dbg1. General";
    public static final String HELP_ANCHOR = "launch_tracermi";
    private final TraceRmiLauncherServicePlugin plugin;
    private MenuActionDockingToolbarButton button;

    public LaunchAction(TraceRmiLauncherServicePlugin plugin) {
        super(NAME, plugin.getName());
        this.plugin = plugin;
        this.setToolBarData(new ToolBarData(ICON, GROUP, "A"));
        this.setHelpLocation(new HelpLocation(plugin.getName(), HELP_ANCHOR));
    }

    protected String[] prependConfigAndLaunch(List<String> menuPath) {
        Program program = this.plugin.currentProgram;
        return (String[])Stream.concat(Stream.of("Configure and Launch " + program.getName() + " using..."), menuPath.stream()).toArray(String[]::new);
    }

    ConfigLast checkSavedConfig(ProgramUserData userData, String propName) {
        Element element;
        if (!propName.startsWith("DBGLAUNCH_")) {
            return null;
        }
        String configName = propName.substring("DBGLAUNCH_".length());
        String propVal = Objects.requireNonNull(userData.getStringProperty(propName, null));
        try {
            element = XmlUtilities.fromString((String)propVal);
        }
        catch (IOException | JDOMException e) {
            Msg.error((Object)((Object)this), (Object)("Could not load launcher config for " + configName + ": " + (Exception)e), (Throwable)e);
            return null;
        }
        SaveState state = new SaveState(element);
        if (!state.hasValue("last")) {
            return null;
        }
        return new ConfigLast(configName, state.getLong("last", 0L));
    }

    ConfigLast findMostRecentConfig() {
        Program program = this.plugin.currentProgram;
        if (program == null) {
            return null;
        }
        ConfigLast best = null;
        ProgramUserData userData = program.getProgramUserData();
        for (String propName : userData.getStringPropertyNames()) {
            ConfigLast candidate = this.checkSavedConfig(userData, propName);
            if (candidate == null) continue;
            if (best == null) {
                best = candidate;
                continue;
            }
            if (candidate.last <= best.last) continue;
            best = candidate;
        }
        return best;
    }

    public List<DockingActionIf> getActionList(ActionContext context) {
        Program program = this.plugin.currentProgram;
        Collection<TraceRmiLaunchOffer> offers = this.plugin.getOffers(program);
        ArrayList<DockingActionIf> actions = new ArrayList<DockingActionIf>();
        HashMap<String, Long> saved = new HashMap<String, Long>();
        if (program != null) {
            ProgramUserData userData = program.getProgramUserData();
            for (String propName : userData.getStringPropertyNames()) {
                ConfigLast check = this.checkSavedConfig(userData, propName);
                if (check == null) continue;
                saved.put(check.configName, check.last);
            }
        }
        for (TraceRmiLaunchOffer offer : offers) {
            actions.add((DockingActionIf)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(offer.getConfigName(), this.plugin.getName()).popupMenuPath(this.prependConfigAndLaunch(offer.getMenuPath()))).popupMenuGroup(offer.getMenuGroup(), offer.getMenuOrder())).popupMenuIcon(offer.getIcon())).helpLocation(offer.getHelpLocation())).enabledWhen(ctx -> true)).onAction(ctx -> this.plugin.configureAndLaunch(offer))).build());
            Long last = (Long)saved.get(offer.getConfigName());
            if (last == null) continue;
            actions.add((DockingActionIf)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(offer.getConfigName(), this.plugin.getName()).popupMenuPath(new String[]{"Re-launch " + program.getName() + " using " + offer.getTitle()})).popupMenuGroup("0", "%016x".formatted(Long.MAX_VALUE - last))).popupMenuIcon(offer.getIcon())).helpLocation(offer.getHelpLocation())).enabledWhen(ctx -> true)).onAction(ctx -> this.plugin.relaunch(offer))).build());
        }
        return actions;
    }

    public JButton doCreateButton() {
        this.button = new MenuActionDockingToolbarButton((MultiActionDockingActionIf)this);
        return this.button;
    }

    public boolean isEnabledForContext(ActionContext context) {
        return this.plugin.currentProgram != null;
    }

    protected TraceRmiLaunchOffer findOffer(ConfigLast last) {
        if (last == null) {
            return null;
        }
        for (TraceRmiLaunchOffer offer : this.plugin.getOffers(this.plugin.currentProgram)) {
            if (!offer.getConfigName().equals(last.configName)) continue;
            return offer;
        }
        return null;
    }

    public void actionPerformed(ActionContext context) {
        ConfigLast last = this.findMostRecentConfig();
        TraceRmiLaunchOffer offer = this.findOffer(last);
        if (offer == null) {
            Swing.runLater(() -> this.button.showPopup());
            return;
        }
        this.plugin.relaunch(offer);
    }

    public String getDescription() {
        Program program = this.plugin.currentProgram;
        if (program == null) {
            return "Launch (program required)";
        }
        ConfigLast last = this.findMostRecentConfig();
        TraceRmiLaunchOffer offer = this.findOffer(last);
        if (last == null) {
            return "Configure and launch " + program.getName();
        }
        return "Re-launch " + program.getName() + " using " + offer.getTitle();
    }

    record ConfigLast(String configName, long last) {
    }

    class MenuActionDockingToolbarButton
    extends MultipleActionDockingToolbarButton {
        public MenuActionDockingToolbarButton(MultiActionDockingActionIf action) {
            super(action);
        }

        protected JPopupMenu doCreateMenu() {
            ActionContext context = this.getActionContext();
            List<DockingActionIf> actionList = LaunchAction.this.getActionList(context);
            PopupMenuHandler handler = new PopupMenuHandler(LaunchAction.this.plugin.getTool().getWindowManager(), context);
            MenuManager manager = new MenuManager(LaunchAction.NAME, '\u0000', LaunchAction.GROUP, true, (MenuHandler)handler, null);
            for (DockingActionIf action : actionList) {
                manager.addAction(action);
            }
            return manager.getPopupMenu();
        }

        protected JPopupMenu showPopup() {
            return super.showPopup();
        }

        public String getToolTipText() {
            return LaunchAction.this.getDescription();
        }
    }
}

