/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.tracermi;

import ghidra.app.plugin.core.debug.service.tracermi.AbstractTraceRmiListener;
import ghidra.app.plugin.core.debug.service.tracermi.TraceRmiPlugin;
import ghidra.debug.api.tracermi.TraceRmiServiceListener;
import ghidra.util.Msg;
import java.io.IOException;
import java.net.SocketAddress;

public class TraceRmiServer
extends AbstractTraceRmiListener {
    public TraceRmiServer(TraceRmiPlugin plugin, SocketAddress address) {
        super(plugin, address);
    }

    @Override
    protected void bind() throws IOException {
        this.socket.bind(this.address);
    }

    @Override
    protected void startServiceLoop() {
        new Thread(this::serviceLoop, "trace-rmi server " + this.socket.getLocalSocketAddress()).start();
    }

    @Override
    protected TraceRmiServiceListener.ConnectMode getConnectMode() {
        return TraceRmiServiceListener.ConnectMode.SERVER;
    }

    protected void serviceLoop() {
        try {
            this.doAccept(null);
        }
        catch (IOException e) {
            if (this.socket.isClosed()) {
                return;
            }
            Msg.error((Object)"Error accepting TraceRmi client", (Object)e);
            return;
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                Msg.error((Object)"Error closing TraceRmi service", (Object)e);
            }
        }
    }
}

