/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.AbstractPeekableIterator;
import ghidra.util.AddressIteratorAdapter;
import ghidra.util.ComparatorMath;
import java.util.Iterator;

public class CachedAddressSetView
implements AddressSetView {
    protected final AddressSetView delegate;
    protected final AddressSet cache = new AddressSet();
    protected final AddressSet known = new AddressSet();
    protected Address minAddress;
    protected Address maxAddress;
    protected Integer numRanges = null;
    protected Long numAddresses = null;

    public CachedAddressSetView(AddressSetView delegate) {
        this.delegate = delegate;
        this.init();
    }

    protected void init() {
        this.minAddress = this.delegate.getMinAddress();
        this.maxAddress = this.delegate.getMaxAddress();
    }

    protected static void addMixed(AddressSet set, Address min, Address max) {
        if (min.getAddressSpace() == max.getAddressSpace()) {
            set.add(min, max);
        } else {
            set.add(min, min.getAddressSpace().getMaxAddress());
            set.add(max.getAddressSpace().getMinAddress(), max);
        }
    }

    protected void ensureKnown(Address min, Address max) {
        block6: {
            AddressRange next;
            if (this.minAddress == null) {
                return;
            }
            if (this.known.contains(min = ComparatorMath.cmax(min, this.minAddress), max = ComparatorMath.cmin(max, this.maxAddress))) {
                return;
            }
            AddressRangeIterator rangesBackward = this.delegate.getAddressRanges(min, false);
            if (rangesBackward.hasNext()) {
                AddressRange prev = (AddressRange)rangesBackward.next();
                this.cache.add(prev);
                CachedAddressSetView.addMixed(this.known, prev.getMinAddress(), min);
            } else {
                CachedAddressSetView.addMixed(this.known, this.minAddress, min);
            }
            AddressRangeIterator rangesForward = this.delegate.getAddressRanges(min, true);
            do {
                if (!rangesForward.hasNext()) {
                    CachedAddressSetView.addMixed(this.known, min, this.maxAddress);
                    break block6;
                }
                next = (AddressRange)rangesForward.next();
                this.cache.add(next);
            } while (next.getMaxAddress().compareTo((Object)max) < 0);
            CachedAddressSetView.addMixed(this.known, min, next.getMaxAddress());
        }
    }

    public boolean contains(Address addr) {
        this.ensureKnown(addr, addr);
        return this.cache.contains(addr);
    }

    public boolean contains(Address start, Address end) {
        this.ensureKnown(start, end);
        return this.cache.contains(start, end);
    }

    public boolean contains(AddressSetView rangeSet) {
        for (AddressRange rng : rangeSet) {
            if (this.contains(rng.getMinAddress(), rng.getMaxAddress())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.minAddress == null;
    }

    public Address getMinAddress() {
        return this.minAddress;
    }

    public Address getMaxAddress() {
        return this.maxAddress;
    }

    public int getNumAddressRanges() {
        if (this.numRanges == null) {
            this.numRanges = this.delegate.getNumAddressRanges();
        }
        return this.numRanges;
    }

    public AddressRangeIterator getAddressRanges() {
        return this.getAddressRanges(true);
    }

    public AddressRangeIterator getAddressRanges(boolean forward) {
        return this.getAddressRanges(forward ? this.minAddress : this.maxAddress, forward);
    }

    public AddressRangeIterator getAddressRanges(Address start, boolean forward) {
        return new CachedRangeIterator(start, forward);
    }

    public Iterator<AddressRange> iterator() {
        return this.getAddressRanges();
    }

    public Iterator<AddressRange> iterator(boolean forward) {
        return this.getAddressRanges(true);
    }

    public Iterator<AddressRange> iterator(Address start, boolean forward) {
        return this.getAddressRanges(start, forward);
    }

    public long getNumAddresses() {
        if (this.numAddresses == null) {
            this.numAddresses = this.delegate.getNumAddresses();
        }
        return this.numAddresses;
    }

    public AddressIterator getAddresses(boolean forward) {
        return new AddressIteratorAdapter((Iterator<AddressRange>)this.getAddressRanges(forward), forward);
    }

    public AddressIterator getAddresses(Address start, boolean forward) {
        return new AddressIteratorAdapter((Iterator<AddressRange>)this.getAddressRanges(start, forward), start, forward);
    }

    public boolean intersects(AddressSetView addrSet) {
        for (AddressRange rng : addrSet) {
            if (!this.intersects(rng.getMinAddress(), rng.getMaxAddress())) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(Address start, Address end) {
        this.ensureKnown(start, end);
        return this.cache.intersects(start, end);
    }

    public AddressSet intersect(AddressSetView view) {
        AddressSet result = new AddressSet();
        for (AddressRange rng : view) {
            result.add((AddressSetView)this.intersectRange(rng.getMinAddress(), rng.getMaxAddress()));
        }
        return result;
    }

    public AddressSet intersectRange(Address start, Address end) {
        this.ensureKnown(start, end);
        return this.cache.intersectRange(start, end);
    }

    public AddressSet union(AddressSetView addrSet) {
        this.ensureKnown(this.minAddress, this.maxAddress);
        return this.cache.union(addrSet);
    }

    public AddressSet subtract(AddressSetView addrSet) {
        this.ensureKnown(this.minAddress, this.maxAddress);
        return this.cache.subtract(addrSet);
    }

    public AddressSet xor(AddressSetView addrSet) {
        this.ensureKnown(this.minAddress, this.maxAddress);
        return this.cache.xor(addrSet);
    }

    public boolean hasSameAddresses(AddressSetView view) {
        for (AddressRange rng : view) {
            Address min = rng.getMinAddress();
            this.ensureKnown(min, rng.getMaxAddress());
            if (this.cache.getRangeContaining(min).equals(rng)) continue;
            return false;
        }
        return true;
    }

    public AddressRange getFirstRange() {
        this.ensureKnown(this.minAddress, this.minAddress);
        return this.cache.getFirstRange();
    }

    public AddressRange getLastRange() {
        this.ensureKnown(this.maxAddress, this.maxAddress);
        return this.cache.getLastRange();
    }

    public AddressRange getRangeContaining(Address address) {
        this.ensureKnown(address, address);
        return this.cache.getRangeContaining(address);
    }

    public Address findFirstAddressInCommon(AddressSetView set) {
        for (AddressRange rng : set) {
            this.ensureKnown(rng.getMinAddress(), rng.getMaxAddress());
            AddressSet ir = this.cache.intersectRange(rng.getMinAddress(), rng.getMaxAddress());
            if (ir == null) continue;
            return ir.getMinAddress();
        }
        return null;
    }

    public void invalidate() {
        this.cache.clear();
        this.known.clear();
        this.numRanges = null;
        this.numAddresses = null;
        this.init();
    }

    protected class CachedRangeIterator
    extends AbstractPeekableIterator<AddressRange>
    implements AddressRangeIterator {
        protected final Address start;
        protected final boolean forward;
        protected Address cur;

        public CachedRangeIterator(Address start, boolean forward) {
            this.start = start;
            this.forward = forward;
            this.cur = start;
        }

        public Iterator<AddressRange> iterator() {
            return this;
        }

        @Override
        protected AddressRange seekNext() {
            if (this.cur == null) {
                return null;
            }
            CachedAddressSetView.this.ensureKnown(this.cur, this.cur);
            AddressRangeIterator it = CachedAddressSetView.this.cache.getAddressRanges(this.cur, this.forward);
            if (!it.hasNext()) {
                return null;
            }
            AddressRange result = (AddressRange)it.next();
            this.cur = this.forward ? result.getMaxAddress().next() : result.getMinAddress().previous();
            return result;
        }
    }
}

