/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.go.ipc;

import ghidra.app.plugin.core.go.exception.UnableToGetLockException;
import ghidra.framework.Application;
import ghidra.util.Msg;
import java.io.File;
import java.io.IOException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Path;
import java.util.function.Supplier;
import utilities.util.FileUtilities;

public abstract class GhidraGoIPC {
    protected final Path channelPath = Path.of(Application.getUserTempDirectory().getPath(), "ghidraGo");
    protected final Path urlFilesPath = this.channelPath.resolve("urls");
    protected final Path listenerLockPath = this.channelPath.resolve("listenerLock");
    protected final Path listenerReadyLockPath = this.channelPath.resolve("listenerReadyLock");
    protected final Path senderLockPath = this.channelPath.resolve("senderLock");

    protected GhidraGoIPC() throws IOException {
        try {
            FileUtilities.checkedMkdir((File)this.channelPath.toFile());
            FileUtilities.checkedMkdir((File)this.urlFilesPath.toFile());
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Unable to create IPC directories.");
            throw e;
        }
    }

    public abstract void dispose();

    public boolean isGhidraListening() {
        if (this.listenerLockPath.toFile().exists() && this.listenerReadyLockPath.toFile().exists()) {
            return this.isFileLocked(this.listenerLockPath) && this.isFileLocked(this.listenerReadyLockPath);
        }
        return false;
    }

    private boolean isFileLocked(Path lockPath) {
        try {
            return !GhidraGoIPC.doLockedAction(lockPath, false, () -> true);
        }
        catch (UnableToGetLockException | OverlappingFileLockException e) {
            return true;
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean doLockedAction(Path lockPath, boolean waitForLock, Supplier<Boolean> action) throws OverlappingFileLockException, UnableToGetLockException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ void lambda$doLockedAction$1(Path lockPath, IOException e) {
        Msg.showError(GhidraGoIPC.class, null, (String)"Could not perform exclusive action", (Object)("Another process is currently holding the lock at " + lockPath), (Throwable)e);
    }
}

