/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.concept;

import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.main.KeyStore;
import agent.dbgmodel.dbgmodel.main.ModelObject;
import agent.dbgmodel.impl.dbgmodel.concept.IndexableConceptInternal;
import agent.dbgmodel.impl.dbgmodel.main.ModelObjectImpl;
import agent.dbgmodel.jna.dbgmodel.concept.IIndexableConcept;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;

public class IndexableConceptImpl
implements IndexableConceptInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IIndexableConcept jnaData;
    private ModelObject indexers;
    private KeyStore metadata;

    public IndexableConceptImpl(IIndexableConcept jnaData) {
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    @Override
    public long getDimensionality(ModelObject contextObject) {
        Pointer pContextObject = contextObject.getPointer();
        WinDef.ULONGLONGByReference pDimensionality = new WinDef.ULONGLONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetDimensionality(pContextObject, pDimensionality));
        return pDimensionality.getValue().longValue();
    }

    @Override
    public ModelObject getAt(ModelObject contextObject, long indexerCount, Pointer[] ppIndexers) {
        Pointer pContextObject = contextObject.getPointer();
        WinDef.ULONGLONG ulIndexerCount = new WinDef.ULONGLONG(indexerCount);
        PointerByReference ppObject = new PointerByReference();
        PointerByReference ppMetadata = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetAt(pContextObject, ulIndexerCount, ppIndexers, ppObject, ppMetadata));
        return ModelObjectImpl.getObjectWithMetadata(ppObject, ppMetadata);
    }

    public ModelObject getIndexers() {
        return this.indexers;
    }

    @Override
    public KeyStore getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(KeyStore metdata) {
        this.metadata = metdata;
    }
}

