/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.concept;

import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.main.KeyStore;
import agent.dbgmodel.dbgmodel.main.ModelObject;
import agent.dbgmodel.impl.dbgmodel.concept.StringDisplayableConceptInternal;
import agent.dbgmodel.jna.dbgmodel.concept.IStringDisplayableConcept;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinNT;

public class StringDisplayableConceptImpl
implements StringDisplayableConceptInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IStringDisplayableConcept jnaData;
    private KeyStore metadata;

    public StringDisplayableConceptImpl(IStringDisplayableConcept jnaData) {
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    @Override
    public String toDisplayString(ModelObject contextObject, KeyStore mdata) {
        Pointer pContextObject = contextObject.getPointer();
        Pointer pMetadata = mdata == null ? null : mdata.getPointer();
        WTypes.BSTRByReference bref = new WTypes.BSTRByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.ToDisplayString(pContextObject, pMetadata, bref));
        WTypes.BSTR bstr = bref.getValue();
        String displayString = bstr.getValue();
        OleAuto.INSTANCE.SysFreeString(bstr);
        return displayString;
    }

    @Override
    public KeyStore getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(KeyStore metdata) {
        this.metadata = metdata;
    }
}

