/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.jna.dbgmodel;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.Unknown;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import ghidra.util.Msg;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UnknownWithUtils
extends Unknown {
    public static final RefAnalyzer ANALYZER = new DisabledRefAnalyzer();

    public static void pause() {
        try {
            new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void error(String message) {
        Msg.error(UnknownWithUtils.class, (Object)message, (Throwable)new Throwable());
    }

    public UnknownWithUtils() {
    }

    public UnknownWithUtils(Pointer pvInstance) {
        super(pvInstance);
        ANALYZER.observedAddRefViaResult(pvInstance, this);
    }

    protected WinNT.HRESULT _invokeHR(VTableIndex idx, Object ... args) {
        return (WinNT.HRESULT)this._invokeNativeObject(idx.getIndex(), args, WinNT.HRESULT.class);
    }

    public WinNT.HRESULT QueryInterface(Guid.REFIID riid, PointerByReference ppvObject) {
        ANALYZER.observeCall(this, "QueryInterface");
        WinNT.HRESULT hr = super.QueryInterface(riid, ppvObject);
        ANALYZER.observedQueryInterface(riid, ppvObject, hr, this);
        return hr;
    }

    public int AddRef() {
        int count = super.AddRef();
        ANALYZER.observedAddRef(count, this);
        return count;
    }

    public int Release() {
        int count = super.Release();
        ANALYZER.observedRelease(count, this);
        return count;
    }

    public int getRefCount() {
        int count;
        int added = super.AddRef();
        if (added - 1 != (count = super.Release())) {
            Msg.warn((Object)((Object)this), (Object)("COM ref-count impl anomaly wrapper=" + this + ", added=" + added + ", count=" + count));
        }
        return count;
    }

    public static interface RefAnalyzer {
        default public void observeCall(Pointer ptr, UnknownWithUtils wrapper, String name) {
        }

        default public void observeCall(UnknownWithUtils wrapper, String name) {
        }

        default public void observedAddRefViaResult(Pointer ptr, UnknownWithUtils wrapper) {
        }

        default public void observedQueryInterface(Guid.REFIID riid, PointerByReference ppvObject, WinNT.HRESULT hr, UnknownWithUtils wrapper) {
        }

        default public void observedAddRef(int count, UnknownWithUtils wrapper) {
        }

        default public void observedRelease(int count, UnknownWithUtils wrapper) {
        }

        default public void checkLeaks() {
        }
    }

    public static interface VTableIndex {
        public int getIndex();

        public static <I extends Enum<I>> int follow(Class<I> prev) {
            Enum[] all = (Enum[])prev.getEnumConstants();
            int start = ((VTableIndex)((Object)all[0])).getIndex() - all[0].ordinal();
            return all.length + start;
        }
    }

    public static class DisabledRefAnalyzer
    implements RefAnalyzer {
    }

    public static class EnabledRefAnalyzer
    implements RefAnalyzer {
        public static final Map<Long, RefAnalyzerEntry> REFS = new HashMap<Long, RefAnalyzerEntry>();
        public static final List<Long> QIS = new ArrayList<Long>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected RefAnalyzerEntry getEntry(Pointer ptr) {
            Map<Long, RefAnalyzerEntry> map = REFS;
            synchronized (map) {
                return REFS.get(Pointer.nativeValue((Pointer)ptr));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected RefAnalyzerEntry getEntryOrCreate(Pointer ptr) {
            Map<Long, RefAnalyzerEntry> map = REFS;
            synchronized (map) {
                return REFS.computeIfAbsent(Pointer.nativeValue((Pointer)ptr), addr -> new RefAnalyzerEntry(ptr));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected RefAnalyzerEntry removeEntry(Pointer ptr) {
            Map<Long, RefAnalyzerEntry> map = REFS;
            synchronized (map) {
                return REFS.remove(Pointer.nativeValue((Pointer)ptr));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void expectWrapper(Pointer ptr) {
            Map<Long, RefAnalyzerEntry> map = REFS;
            synchronized (map) {
                QIS.add(Pointer.nativeValue((Pointer)ptr));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unexpectWrapper(Pointer ptr) {
            Map<Long, RefAnalyzerEntry> map = REFS;
            synchronized (map) {
                QIS.remove(Pointer.nativeValue((Pointer)ptr));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void observeCall(Pointer ptr, UnknownWithUtils wrapper, String name) {
            Map<Long, RefAnalyzerEntry> map = REFS;
            synchronized (map) {
                RefAnalyzerEntry entry = this.getEntryOrCreate(ptr);
                long actual = entry.verifyCount(wrapper, name);
                entry.verifyValid(actual, wrapper, name);
                entry.verifyThread();
            }
        }

        @Override
        public void observeCall(UnknownWithUtils wrapper, String name) {
            this.observeCall(wrapper.getPointer(), wrapper, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void observedAddRefViaResult(Pointer ptr, UnknownWithUtils wrapper) {
            Msg.debug((Object)this, (Object)("COM Presumed AddRef: " + ptr + ", wrapper=" + wrapper));
            Map<Long, RefAnalyzerEntry> map = REFS;
            synchronized (map) {
                this.unexpectWrapper(ptr);
                RefAnalyzerEntry entry = this.getEntryOrCreate(ptr);
                Msg.debug((Object)this, (Object)("COM count after AddRef: " + wrapper + " mine=" + entry.myCount));
                ++entry.myCount;
            }
        }

        @Override
        public void observedQueryInterface(Guid.REFIID riid, PointerByReference ppvObject, WinNT.HRESULT hr, UnknownWithUtils wrapper) {
            Pointer ptr = ppvObject.getValue();
            Msg.debug((Object)this, (Object)("COM QueryInterface: " + wrapper + "(riid->" + riid.getValue().toGuidString() + ",ppvObject->" + ptr + ") = " + hr));
            this.expectWrapper(ptr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void observedAddRef(int count, UnknownWithUtils wrapper) {
            Msg.debug((Object)this, (Object)("COM AddRef: " + wrapper + "() = " + count));
            Pointer ptr = wrapper.getPointer();
            Map<Long, RefAnalyzerEntry> map = REFS;
            synchronized (map) {
                RefAnalyzerEntry entry = this.getEntry(ptr);
                if (entry == null) {
                    UnknownWithUtils.error("COM AddRef on non-refed object ptr=" + ptr + ", wrapper=" + wrapper);
                    return;
                }
                ++entry.myCount;
                entry.verifyValid(count, wrapper, "AddRef");
                entry.verifyThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void observedRelease(int count, UnknownWithUtils wrapper) {
            Msg.debug((Object)this, (Object)("COM Release: " + wrapper + "() = " + count));
            Pointer ptr = wrapper.getPointer();
            Map<Long, RefAnalyzerEntry> map = REFS;
            synchronized (map) {
                RefAnalyzerEntry entry = this.getEntry(ptr);
                if (entry == null) {
                    UnknownWithUtils.error("COM Released on non-refed object ptr=" + ptr + ", wrapper=" + wrapper);
                    return;
                }
                --entry.myCount;
                Msg.debug((Object)this, (Object)("COM count after Release: " + wrapper + " mine=" + entry.myCount + ", actual=" + count));
                if (entry.myCount == 0L) {
                    this.removeEntry(ptr);
                }
                entry.verifyValid(count, wrapper, "Release");
                entry.verifyThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void checkLeaks() {
            System.gc();
            Map<Long, RefAnalyzerEntry> map = REFS;
            synchronized (map) {
                for (RefAnalyzerEntry entry : REFS.values()) {
                    if (entry.myCount == 0L) continue;
                    Msg.warn((Object)this, (Object)("COM potential ref leak: ptr=" + entry.ptr + ", count=" + entry.myCount));
                }
                Iterator<Object> iterator = QIS.iterator();
                while (iterator.hasNext()) {
                    long addr = (Long)iterator.next();
                    Msg.error((Object)this, (Object)("Observed QueryInterface without a wrapper: ptr=0x" + Long.toHexString(addr)));
                }
            }
        }
    }

    public static class RefAnalyzerEntry {
        public final Pointer ptr;
        public long myCount = 0L;
        public Thread thread;

        public RefAnalyzerEntry(Pointer ptr) {
            this.ptr = ptr;
        }

        public void verifyValid(long actual, UnknownWithUtils wrapper, String name) {
            if (this.myCount < 0L || actual < 0L) {
                UnknownWithUtils.error("COM mine or actual ref-count below 0 in " + name + " wrapper=" + wrapper + ", ptr=" + this.ptr + ", myCount=" + this.myCount + ", actual=" + actual);
            }
        }

        public int verifyCount(UnknownWithUtils wrapper, String name) {
            int actual = wrapper.getRefCount();
            this.verifyValid(actual, wrapper, name);
            return actual;
        }

        public void verifyThread() {
            Thread current = Thread.currentThread();
            if (this.thread == null) {
                this.thread = current;
            }
            if (this.thread != current && current.getName().contains("Cleaner")) {
                return;
            }
        }
    }
}

