/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.model.impl;

import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgEventsListener;
import agent.dbgeng.manager.DbgProcess;
import agent.dbgeng.manager.DbgReason;
import agent.dbgeng.manager.DbgState;
import agent.dbgeng.manager.DbgStateListener;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.breakpoint.DbgBreakpointInfo;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.model.iface1.DbgModelTargetAccessConditioned;
import agent.dbgeng.model.iface1.DbgModelTargetBptHelper;
import agent.dbgeng.model.iface1.DbgModelTargetExecutionStateful;
import agent.dbgeng.model.iface1.DbgModelTargetMethod;
import agent.dbgeng.model.iface2.DbgModelTargetAvailable;
import agent.dbgeng.model.iface2.DbgModelTargetAvailableContainer;
import agent.dbgeng.model.iface2.DbgModelTargetBreakpointContainer;
import agent.dbgeng.model.iface2.DbgModelTargetBreakpointSpec;
import agent.dbgeng.model.iface2.DbgModelTargetDebugContainer;
import agent.dbgeng.model.iface2.DbgModelTargetMemoryContainer;
import agent.dbgeng.model.iface2.DbgModelTargetModule;
import agent.dbgeng.model.iface2.DbgModelTargetModuleContainer;
import agent.dbgeng.model.iface2.DbgModelTargetObject;
import agent.dbgeng.model.iface2.DbgModelTargetProcess;
import agent.dbgeng.model.iface2.DbgModelTargetProcessContainer;
import agent.dbgeng.model.iface2.DbgModelTargetRegister;
import agent.dbgeng.model.iface2.DbgModelTargetRegisterBank;
import agent.dbgeng.model.iface2.DbgModelTargetRegisterContainer;
import agent.dbgeng.model.iface2.DbgModelTargetSession;
import agent.dbgeng.model.iface2.DbgModelTargetSessionAttributes;
import agent.dbgeng.model.iface2.DbgModelTargetSessionContainer;
import agent.dbgeng.model.iface2.DbgModelTargetStack;
import agent.dbgeng.model.iface2.DbgModelTargetStackFrame;
import agent.dbgeng.model.iface2.DbgModelTargetTTD;
import agent.dbgeng.model.iface2.DbgModelTargetThread;
import agent.dbgeng.model.iface2.DbgModelTargetThreadContainer;
import agent.dbgmodel.dbgmodel.main.ModelObject;
import agent.dbgmodel.jna.dbgmodel.DbgModelNative;
import agent.dbgmodel.model.impl.DbgModel2Impl;
import agent.dbgmodel.model.impl.DbgModel2TargetObjectImpl;
import agent.dbgmodel.model.impl.DbgModel2TargetProxy;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetAccessConditioned;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetRegisterBank;
import ghidra.dbg.target.TargetRegisterContainer;
import ghidra.dbg.target.TargetStack;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.util.PathUtils;
import ghidra.util.datastruct.ListenerSet;
import java.lang.invoke.MethodHandles;
import java.lang.ref.Cleaner;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DelegateDbgModel2TargetObject
extends DbgModel2TargetObjectImpl
implements DbgModelTargetAccessConditioned,
DbgModelTargetExecutionStateful,
DbgModel2TargetProxy,
DbgModelTargetBptHelper {
    protected final DbgStateListener accessListener = this::checkExited;
    protected static final Cleaner CLEANER = Cleaner.create();
    protected static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    protected final ProxyState state;
    protected final Cleaner.Cleanable cleanable;
    private boolean breakpointEnabled;
    private final ListenerSet<TargetBreakpointSpec.TargetBreakpointAction> breakpointActions = new ListenerSet(TargetBreakpointSpec.TargetBreakpointAction.class, false);

    protected static String indexObject(ModelObject obj) {
        return obj.getSearchKey();
    }

    public static String keyObject(ModelObject obj) {
        return PathUtils.makeKey((String)DelegateDbgModel2TargetObject.indexObject(obj));
    }

    protected static Class<? extends DbgModelTargetObject> lookupWrapperType(String type, String parentName) {
        switch (type) {
            case "Available": {
                return DbgModelTargetAvailableContainer.class;
            }
            case "Sessions": {
                return DbgModelTargetSessionContainer.class;
            }
            case "Processes": {
                return DbgModelTargetProcessContainer.class;
            }
            case "Threads": {
                return DbgModelTargetThreadContainer.class;
            }
            case "Modules": {
                return DbgModelTargetModuleContainer.class;
            }
            case "Frames": {
                return DbgModelTargetStack.class;
            }
            case "Registers": {
                return DbgModelTargetRegisterContainer.class;
            }
            case "Attributes": {
                return DbgModelTargetSessionAttributes.class;
            }
            case "Breakpoints": {
                return DbgModelTargetBreakpointContainer.class;
            }
            case "cursession": {
                return DbgModelTargetSession.class;
            }
            case "curprocess": {
                return DbgModelTargetProcess.class;
            }
            case "curthread": {
                return DbgModelTargetThread.class;
            }
            case "curframe": {
                return DbgModelTargetStackFrame.class;
            }
            case "User": {
                return DbgModelTargetRegisterBank.class;
            }
            case "TTD": {
                return DbgModelTargetTTD.class;
            }
            case "Debug": {
                return DbgModelTargetDebugContainer.class;
            }
        }
        if (parentName != null) {
            switch (parentName) {
                case "Available": {
                    return DbgModelTargetAvailable.class;
                }
                case "Sessions": {
                    return DbgModelTargetSession.class;
                }
                case "Processes": {
                    return DbgModelTargetProcess.class;
                }
                case "Threads": {
                    return DbgModelTargetThread.class;
                }
                case "Modules": {
                    return DbgModelTargetModule.class;
                }
                case "Frames": {
                    return DbgModelTargetStackFrame.class;
                }
                case "Breakpoints": {
                    return DbgModelTargetBreakpointSpec.class;
                }
                case "FloatingPoint": 
                case "Kernel": 
                case "SIMD": 
                case "VFP": 
                case "User": {
                    return DbgModelTargetRegister.class;
                }
            }
        }
        return null;
    }

    public static DbgModelTargetObject makeProxy(DbgModel2Impl model, DbgModelTargetObject parent, String key, ModelObject object) {
        ArrayList<Class<? extends TargetObject>> mixins = new ArrayList<Class<? extends TargetObject>>();
        String lkey = key;
        String pname = parent.getName();
        if (object.getKind().equals((Object)DbgModelNative.ModelObjectKind.OBJECT_METHOD)) {
            mixins.add(DbgModelTargetMethod.class);
        } else {
            Class<? extends DbgModelTargetObject> mixin = DelegateDbgModel2TargetObject.lookupWrapperType(lkey, pname);
            if (mixin != null) {
                mixins.add(mixin);
            }
        }
        return new DelegateDbgModel2TargetObject(model, parent, key, object, mixins).getProxy();
    }

    public DelegateDbgModel2TargetObject(DbgModel2Impl model, DbgModelTargetObject parent, String key, ModelObject modelObject, List<Class<? extends TargetObject>> mixins) {
        super(model, mixins, model, parent.getProxy(), key, DelegateDbgModel2TargetObject.getHintForObject(modelObject));
        this.state = new ProxyState(model, modelObject);
        this.cleanable = CLEANER.register(this, this.state);
        this.getManager().addStateListener(this.accessListener);
        if (this.proxy instanceof DbgEventsListener) {
            model.getManager().addEventsListener((DbgEventsListener)this.proxy);
        }
        this.setModelObject(modelObject);
        this.init();
    }

    public DelegateDbgModel2TargetObject clone(String key, ModelObject modelObject) {
        DbgModelTargetObject p = (DbgModelTargetObject)this.getParent();
        ArrayList<Class<? extends TargetObject>> mixins = new ArrayList<Class<? extends TargetObject>>();
        Class<? extends DbgModelTargetObject> mixin = DelegateDbgModel2TargetObject.lookupWrapperType(key, p.getName());
        if (mixin != null) {
            mixins.add(mixin);
        }
        DelegateDbgModel2TargetObject delegate = new DelegateDbgModel2TargetObject(this.getModel(), p, key, modelObject, mixins);
        return delegate;
    }

    public DbgModelTargetObject getProxy() {
        return (DbgModelTargetObject)this.proxy;
    }

    protected static String getHintForObject(ModelObject obj) {
        Object ret;
        DbgModelNative.ModelObjectKind kind = obj.getKind();
        Object object = ret = kind == null ? "" : kind.name();
        if (kind.equals((Object)DbgModelNative.ModelObjectKind.OBJECT_INTRINSIC)) {
            ret = (String)ret + " " + obj.getValueString();
        }
        return ret;
    }

    protected void doInvalidate(TargetObject branch, String reason) {
        super.doInvalidate(branch, reason);
        this.getManager().removeStateListener(this.accessListener);
    }

    protected void checkExited(DbgState state, DbgCause cause) {
        TargetExecutionStateful.TargetExecutionState exec = TargetExecutionStateful.TargetExecutionState.INACTIVE;
        switch (state) {
            case NOT_STARTED: {
                exec = TargetExecutionStateful.TargetExecutionState.INACTIVE;
                break;
            }
            case STARTING: {
                exec = TargetExecutionStateful.TargetExecutionState.ALIVE;
                break;
            }
            case RUNNING: {
                exec = TargetExecutionStateful.TargetExecutionState.RUNNING;
                this.resetModified();
                this.onRunning();
                break;
            }
            case STOPPED: {
                exec = TargetExecutionStateful.TargetExecutionState.STOPPED;
                this.onStopped();
                break;
            }
            case EXIT: {
                exec = TargetExecutionStateful.TargetExecutionState.TERMINATED;
                this.onExit();
                break;
            }
            case SESSION_EXIT: {
                this.getModel().close();
                return;
            }
        }
        if (this.proxy instanceof TargetExecutionStateful) {
            if (this.proxy instanceof DbgModelTargetSession) {
                if (state != DbgState.EXIT) {
                    this.setExecutionState(exec, "Refreshed");
                }
            } else {
                TargetExecutionStateful.TargetExecutionState previous = this.getExecutionState();
                if (!previous.equals((Object)TargetExecutionStateful.TargetExecutionState.INACTIVE)) {
                    this.setExecutionState(exec, "Refreshed");
                }
            }
        }
    }

    private void invalidate() {
        if (this.proxy instanceof DbgModelTargetMemoryContainer || this.proxy instanceof DbgModelTargetBreakpointContainer || this.proxy instanceof DbgModelTargetRegisterContainer || this.proxy instanceof DbgModelTargetRegisterBank || this.proxy instanceof DbgModelTargetStackFrame || this.proxy instanceof DbgModelTargetStack || this.proxy instanceof DbgModelTargetTTD) {
            return;
        }
    }

    public void init() {
        Long offset;
        if (PathUtils.isLink((List)this.parent.getPath(), (String)this.proxy.getName(), (List)this.proxy.getPath())) {
            return;
        }
        DbgManagerImpl manager = this.getModel().getManager();
        boolean kernelMode = manager.isKernelMode();
        if (this.proxy instanceof DbgModelTargetSession) {
            DbgModelTargetSession targetSession = (DbgModelTargetSession)this.proxy;
            targetSession.getSession(false);
        }
        if (this.proxy instanceof DbgModelTargetProcess) {
            DbgModelTargetProcess targetProcess = (DbgModelTargetProcess)this.proxy;
            DbgProcess process = targetProcess.getProcess(false);
            if (kernelMode && (offset = process.getOffset()) == null) {
                return;
            }
        }
        if (this.proxy instanceof DbgModelTargetThread) {
            DbgModelTargetThread targetThread = (DbgModelTargetThread)this.proxy;
            DbgThread thread = targetThread.getThread(false);
            if (kernelMode && (offset = thread.getOffset()) == null) {
                return;
            }
        }
        if (this.getModel().isSuppressDescent()) {
            return;
        }
        if (this.proxy instanceof DbgModelTargetSession || this.proxy instanceof DbgModelTargetProcess || this.proxy instanceof DbgModelTargetThread) {
            this.requestAttributes(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
            return;
        }
        if (this.proxy instanceof DbgModelTargetRegisterContainer || this.proxy instanceof DbgModelTargetRegisterBank || this.proxy.getName().equals("Stack") || this.proxy.getName().equals("Debug")) {
            this.requestAttributes(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
            return;
        }
        if (this.proxy instanceof DbgModelTargetProcessContainer || this.proxy instanceof DbgModelTargetThreadContainer || this.proxy instanceof DbgModelTargetModuleContainer || this.proxy instanceof DbgModelTargetBreakpointContainer || this.proxy instanceof DbgModelTargetStack) {
            this.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
            return;
        }
    }

    public void onRunning() {
        this.invalidate();
        this.setAccessible(false);
    }

    public void onStopped() {
        this.setAccessible(true);
    }

    public void onExit() {
        this.setAccessible(true);
    }

    public boolean isAccessible() {
        return this.accessible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessible(boolean accessible) {
        Map map = this.attributes;
        synchronized (map) {
            if (this.accessible == accessible) {
                return;
            }
            this.accessible = accessible;
        }
        if (this.proxy instanceof TargetAccessConditioned) {
            this.changeAttributes(List.of(), List.of(), Map.of("_accessible", accessible), "Accessibility changed");
        }
    }

    @Override
    public DelegateDbgModel2TargetObject getDelegate() {
        return this;
    }

    public DbgBreakpointInfo getBreakpointInfo() {
        return (DbgBreakpointInfo)bptInfoMap.get(Integer.decode(this.bptId));
    }

    public void setBreakpointId(String id) {
        this.bptId = id;
    }

    public void setBreakpointInfo(DbgBreakpointInfo info) {
        TargetObject id = (TargetObject)this.getCachedAttribute("Id");
        String idstr = id.getCachedAttribute("_value").toString();
        bptInfoMap.put(Integer.decode(idstr), info);
    }

    public boolean isBreakpointEnabled() {
        return this.breakpointEnabled;
    }

    public void setBreakpointEnabled(boolean enabled) {
        this.breakpointEnabled = enabled;
    }

    public ListenerSet<TargetBreakpointSpec.TargetBreakpointAction> getActions() {
        return this.breakpointActions;
    }

    public void threadStateChangedSpecific(DbgState state, DbgReason reason) {
        if (state.equals((Object)DbgState.RUNNING)) {
            return;
        }
        if (this.proxy instanceof TargetThread) {
            DbgModelTargetRegisterContainer container;
            ArrayList<DelegateDbgModel2TargetObject> delegates = new ArrayList<DelegateDbgModel2TargetObject>();
            TargetObject stack = (TargetObject)this.getCachedAttribute("Stack");
            if (stack != null) {
                DbgModelTargetStack frames = (DbgModelTargetStack)stack.getCachedAttribute("Frames");
                delegates.add((DelegateDbgModel2TargetObject)frames.getDelegate());
            }
            if ((container = (DbgModelTargetRegisterContainer)this.getCachedAttribute("Registers")) == null) {
                return;
            }
            delegates.add((DelegateDbgModel2TargetObject)container.getDelegate());
            DbgModelTargetRegisterBank bank = (DbgModelTargetRegisterBank)container.getCachedAttribute("User");
            if (bank == null) {
                return;
            }
            delegates.add((DelegateDbgModel2TargetObject)bank.getDelegate());
            for (DelegateDbgModel2TargetObject delegate : delegates) {
                delegate.threadStateChangedSpecific(state, reason);
            }
        }
        if (this.proxy instanceof TargetRegisterContainer) {
            if (!this.getModel().isSuppressDescent()) {
                this.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
            }
            this.requestAttributes(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
        }
        if (this.proxy instanceof TargetRegisterBank) {
            TargetRegisterBank bank = (TargetRegisterBank)this.proxy;
            this.requestAttributes(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER).thenAccept(__ -> bank.readRegistersNamed(this.getCachedAttributes().keySet()));
        }
        if (this.proxy instanceof TargetStack) {
            this.requestAttributes(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
            this.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER).thenAccept(__ -> {
                for (TargetObject obj : this.getCachedElements().values()) {
                    if (!(obj instanceof TargetStackFrame)) continue;
                    DbgModelTargetObject frame = (DbgModelTargetObject)obj;
                    DelegateDbgModel2TargetObject delegate = (DelegateDbgModel2TargetObject)frame.getDelegate();
                    delegate.threadStateChangedSpecific(state, reason);
                }
            });
        }
        if (this.proxy instanceof TargetStackFrame) {
            this.requestAttributes(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
        }
    }

    protected static class ProxyState
    implements Runnable {
        protected final DbgModel2Impl model;
        protected final ModelObject modelObject;

        public ProxyState(DbgModel2Impl model, ModelObject modelObject) {
            this.model = model;
            this.modelObject = modelObject;
        }

        @Override
        public void run() {
            this.modelObject.dereference();
        }
    }
}

