/*
 * Decompiled with CFR 0.152.
 */
package ghidra.async;

import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;

public class AsyncRace<T> {
    private final Deque<T> finishers = new LinkedList<T>();
    private final Deque<CompletableFuture<? super T>> queue = new LinkedList<CompletableFuture<? super T>>();

    public AsyncRace<T> include(CompletableFuture<? extends T> future) {
        future.thenAccept(t -> {
            AsyncRace asyncRace = this;
            synchronized (asyncRace) {
                if (this.queue.isEmpty()) {
                    this.finishers.offer(t);
                } else {
                    this.queue.poll().complete(t);
                }
            }
        });
        return this;
    }

    public synchronized CompletableFuture<T> next() {
        if (this.finishers.isEmpty()) {
            CompletableFuture future = new CompletableFuture();
            this.queue.offer(future);
            return future;
        }
        return CompletableFuture.completedFuture(this.finishers.poll());
    }
}

