/*
 * Decompiled with CFR 0.152.
 */
package ghidra.comm.packet;

import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

public class DebugByteChannel
implements AsynchronousByteChannel {
    private final AsynchronousByteChannel wrapped;

    public DebugByteChannel(AsynchronousByteChannel wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public void close() throws IOException {
        this.wrapped.close();
    }

    @Override
    public boolean isOpen() {
        return this.wrapped.isOpen();
    }

    @Override
    public <A> void read(ByteBuffer dst, A attachment, CompletionHandler<Integer, ? super A> handler) {
        int start = dst.position();
        CompletableFuture<Integer> future = AsyncUtils.sequence(TypeSpec.INT).then(seq -> AsyncUtils.completable(TypeSpec.INT, this.wrapped::read, dst).handle(seq::next), TypeSpec.INT).then((len, seq) -> {
            if (len == -1) {
                Msg.debug((Object)this, (Object)"Read EOF");
            } else {
                byte[] data = new byte[len.intValue()];
                dst.position(start);
                dst.get(data);
                Msg.debug((Object)this, (Object)("Read: " + NumericUtilities.convertBytesToString((byte[])data)));
            }
            seq.exit(len, null);
        }).finish();
        AsyncUtils.handle(future, attachment, handler);
    }

    @Override
    public Future<Integer> read(ByteBuffer dst) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A> void write(ByteBuffer src, A attachment, CompletionHandler<Integer, ? super A> handler) {
        int start = src.position();
        CompletableFuture<Integer> future = AsyncUtils.sequence(TypeSpec.INT).then(seq -> AsyncUtils.completable(TypeSpec.INT, this.wrapped::write, src).handle(seq::next), TypeSpec.INT).then((len, seq) -> {
            byte[] data = new byte[len.intValue()];
            src.position(start);
            src.get(data);
            Msg.debug((Object)this, (Object)("Wrote: " + NumericUtilities.convertBytesToString((byte[])data)));
            seq.exit(len, null);
        }).finish();
        AsyncUtils.handle(future, attachment, handler);
    }

    @Override
    public Future<Integer> write(ByteBuffer src) {
        throw new UnsupportedOperationException();
    }
}

