/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.target.schema;

import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.SchemaContext;
import ghidra.dbg.target.schema.TargetObjectSchema;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DefaultTargetObjectSchema
implements TargetObjectSchema,
Comparable<DefaultTargetObjectSchema> {
    private static final String INDENT = "  ";
    private final SchemaContext context;
    private final TargetObjectSchema.SchemaName name;
    private final Class<?> type;
    private final Set<Class<? extends TargetObject>> interfaces;
    private final boolean isCanonicalContainer;
    private final Map<String, TargetObjectSchema.SchemaName> elementSchemas;
    private final TargetObjectSchema.SchemaName defaultElementSchema;
    private final TargetObjectSchema.ResyncMode elementResync;
    private final Map<String, TargetObjectSchema.AttributeSchema> attributeSchemas;
    private final TargetObjectSchema.AttributeSchema defaultAttributeSchema;
    private final TargetObjectSchema.ResyncMode attributeResync;

    DefaultTargetObjectSchema(SchemaContext context, TargetObjectSchema.SchemaName name, Class<?> type, Set<Class<? extends TargetObject>> interfaces, boolean isCanonicalContainer, Map<String, TargetObjectSchema.SchemaName> elementSchemas, TargetObjectSchema.SchemaName defaultElementSchema, TargetObjectSchema.ResyncMode elementResync, Map<String, TargetObjectSchema.AttributeSchema> attributeSchemas, TargetObjectSchema.AttributeSchema defaultAttributeSchema, TargetObjectSchema.ResyncMode attributeResync) {
        this.context = context;
        this.name = name;
        this.type = type;
        this.interfaces = Collections.unmodifiableSet(new LinkedHashSet<Class<? extends TargetObject>>(interfaces));
        this.isCanonicalContainer = isCanonicalContainer;
        this.elementSchemas = Collections.unmodifiableMap(new LinkedHashMap<String, TargetObjectSchema.SchemaName>(elementSchemas));
        this.defaultElementSchema = defaultElementSchema;
        this.elementResync = elementResync;
        this.attributeSchemas = Collections.unmodifiableMap(new LinkedHashMap<String, TargetObjectSchema.AttributeSchema>(attributeSchemas));
        this.defaultAttributeSchema = defaultAttributeSchema;
        this.attributeResync = attributeResync;
    }

    @Override
    public SchemaContext getContext() {
        return this.context;
    }

    @Override
    public TargetObjectSchema.SchemaName getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Set<Class<? extends TargetObject>> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public boolean isCanonicalContainer() {
        return this.isCanonicalContainer;
    }

    @Override
    public Map<String, TargetObjectSchema.SchemaName> getElementSchemas() {
        return this.elementSchemas;
    }

    @Override
    public TargetObjectSchema.SchemaName getDefaultElementSchema() {
        return this.defaultElementSchema;
    }

    @Override
    public TargetObjectSchema.ResyncMode getElementResyncMode() {
        return this.elementResync;
    }

    @Override
    public Map<String, TargetObjectSchema.AttributeSchema> getAttributeSchemas() {
        return this.attributeSchemas;
    }

    @Override
    public TargetObjectSchema.AttributeSchema getDefaultAttributeSchema() {
        return this.defaultAttributeSchema;
    }

    @Override
    public TargetObjectSchema.ResyncMode getAttributeResyncMode() {
        return this.attributeResync;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    protected void toString(StringBuilder sb) {
        sb.append("schema ");
        sb.append(this.name);
        if (this.isCanonicalContainer) {
            sb.append("*");
        }
        sb.append(" {\n  ");
        sb.append("ifaces = [");
        for (Class<? extends TargetObject> iface : this.interfaces) {
            sb.append(DebuggerObjectModel.requireIfaceName(iface));
            sb.append(" ");
        }
        sb.append("]\n  ");
        sb.append("elements(resync " + this.elementResync + ") = ");
        sb.append(this.elementSchemas);
        sb.append(" default " + this.defaultElementSchema);
        sb.append("\n  ");
        sb.append("attributes(resync " + this.attributeResync + ") = ");
        sb.append(this.attributeSchemas);
        sb.append(" default " + this.defaultAttributeSchema);
        sb.append("\n}");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultTargetObjectSchema)) {
            return false;
        }
        DefaultTargetObjectSchema that = (DefaultTargetObjectSchema)obj;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.interfaces, that.interfaces)) {
            return false;
        }
        if (this.isCanonicalContainer != that.isCanonicalContainer) {
            return false;
        }
        if (!Objects.equals(this.elementSchemas, that.elementSchemas)) {
            return false;
        }
        if (!Objects.equals(this.defaultElementSchema, that.defaultElementSchema)) {
            return false;
        }
        if (!Objects.equals((Object)this.elementResync, (Object)that.elementResync)) {
            return false;
        }
        if (!Objects.equals(this.attributeSchemas, that.attributeSchemas)) {
            return false;
        }
        if (!Objects.equals(this.defaultAttributeSchema, that.defaultAttributeSchema)) {
            return false;
        }
        return Objects.equals((Object)this.attributeResync, (Object)that.attributeResync);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(DefaultTargetObjectSchema o) {
        return this.name.compareTo(o.name);
    }

    public static class DefaultAttributeSchema
    implements TargetObjectSchema.AttributeSchema,
    Comparable<DefaultAttributeSchema> {
        private final String name;
        private final TargetObjectSchema.SchemaName schema;
        private final boolean isRequired;
        private final boolean isFixed;
        private final boolean isHidden;

        public DefaultAttributeSchema(String name, TargetObjectSchema.SchemaName schema, boolean isRequired, boolean isFixed, boolean isHidden) {
            if (name.equals("") && isRequired) {
                throw new IllegalArgumentException("The default attribute schema cannot be required");
            }
            this.name = name;
            this.schema = schema;
            this.isRequired = isRequired;
            this.isFixed = isFixed;
            this.isHidden = isHidden;
        }

        public String toString() {
            return String.format("<attr name=%s schema=%s required=%s fixed=%s hidden=%s>", this.name, this.schema, this.isRequired, this.isFixed, this.isHidden);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DefaultAttributeSchema)) {
                return false;
            }
            DefaultAttributeSchema that = (DefaultAttributeSchema)obj;
            if (!Objects.equals(this.name, that.name)) {
                return false;
            }
            if (!Objects.equals(this.schema, that.schema)) {
                return false;
            }
            if (this.isRequired != that.isRequired) {
                return false;
            }
            if (this.isFixed != that.isFixed) {
                return false;
            }
            return this.isHidden == that.isHidden;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(DefaultAttributeSchema o) {
            return this.name.compareTo(o.name);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public TargetObjectSchema.SchemaName getSchema() {
            return this.schema;
        }

        @Override
        public boolean isRequired() {
            return this.isRequired;
        }

        @Override
        public boolean isFixed() {
            return this.isFixed;
        }

        @Override
        public boolean isHidden() {
            return this.isHidden;
        }
    }
}

