/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.util;

import ghidra.dbg.util.PathPattern;
import ghidra.dbg.util.PathPredicates;
import ghidra.dbg.util.PathUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class PathMatcher
implements PathPredicates {
    protected static final Set<String> WILD_SINGLETON = Set.of("");
    protected final Set<PathPattern> patterns = new HashSet<PathPattern>();

    public void addPattern(List<String> pattern) {
        this.patterns.add(new PathPattern(pattern));
    }

    public void addPattern(PathPattern pattern) {
        this.patterns.add(pattern);
    }

    public void addAll(PathMatcher matcher) {
        this.patterns.addAll(matcher.patterns);
    }

    public String toString() {
        return String.format("<PathMatcher\n  %s\n>", StringUtils.join(this.patterns, (String)"\n  "));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PathMatcher)) {
            return false;
        }
        PathMatcher that = (PathMatcher)obj;
        return Objects.equals(this.patterns, that.patterns);
    }

    @Override
    public PathPredicates or(PathPredicates that) {
        PathMatcher result = new PathMatcher();
        result.patterns.addAll(this.patterns);
        if (that instanceof PathMatcher) {
            PathMatcher matcher = (PathMatcher)that;
            result.patterns.addAll(matcher.patterns);
        } else if (that instanceof PathPattern) {
            result.patterns.add((PathPattern)that);
        } else {
            throw new AssertionError();
        }
        return result;
    }

    protected boolean anyPattern(Predicate<PathPattern> pred) {
        for (PathPattern p : this.patterns) {
            if (!pred.test(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(List<String> path) {
        return this.anyPattern(p -> p.matches(path));
    }

    @Override
    public boolean successorCouldMatch(List<String> path, boolean strict) {
        return this.anyPattern(p -> p.successorCouldMatch(path, strict));
    }

    @Override
    public boolean ancestorMatches(List<String> path, boolean strict) {
        return this.anyPattern(p -> p.ancestorMatches(path, strict));
    }

    @Override
    public boolean ancestorCouldMatchRight(List<String> path, boolean strict) {
        return this.anyPattern(p -> p.ancestorCouldMatchRight(path, strict));
    }

    @Override
    public List<String> getSingletonPath() {
        if (this.patterns.size() != 1) {
            return null;
        }
        return this.patterns.iterator().next().getSingletonPath();
    }

    @Override
    public PathPattern getSingletonPattern() {
        if (this.patterns.size() != 1) {
            return null;
        }
        return this.patterns.iterator().next();
    }

    @Override
    public Collection<PathPattern> getPatterns() {
        return this.patterns;
    }

    protected void coalesceWilds(Set<String> result) {
        if (result.contains("")) {
            result.removeIf(PathUtils::isName);
            result.add("");
        }
        if (result.contains("[]")) {
            result.removeIf(PathUtils::isIndex);
            result.add("[]");
        }
    }

    @Override
    public Set<String> getNextKeys(List<String> path) {
        HashSet<String> result = new HashSet<String>();
        for (PathPattern pattern : this.patterns) {
            result.addAll(pattern.getNextKeys(path));
        }
        this.coalesceWilds(result);
        return result;
    }

    @Override
    public Set<String> getNextNames(List<String> path) {
        HashSet<String> result = new HashSet<String>();
        for (PathPattern pattern : this.patterns) {
            result.addAll(pattern.getNextNames(path));
            if (!result.contains("")) continue;
            return WILD_SINGLETON;
        }
        return result;
    }

    @Override
    public Set<String> getNextIndices(List<String> path) {
        HashSet<String> result = new HashSet<String>();
        for (PathPattern pattern : this.patterns) {
            result.addAll(pattern.getNextIndices(path));
            if (!result.contains("")) continue;
            return WILD_SINGLETON;
        }
        return result;
    }

    @Override
    public Set<String> getPrevKeys(List<String> path) {
        HashSet<String> result = new HashSet<String>();
        for (PathPattern pattern : this.patterns) {
            result.addAll(pattern.getPrevKeys(path));
        }
        this.coalesceWilds(result);
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.patterns.isEmpty();
    }

    @Override
    public PathMatcher applyKeys(PathPredicates.Align align, List<String> indices) {
        PathMatcher result = new PathMatcher();
        for (PathPattern pat : this.patterns) {
            result.addPattern((PathPattern)pat.applyKeys(align, (List)indices));
        }
        return result;
    }

    @Override
    public PathMatcher removeRight(int count) {
        PathMatcher result = new PathMatcher();
        for (PathPattern pat : this.patterns) {
            pat.doRemoveRight(count, result);
        }
        return result;
    }
}

