/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.framework.options.OptionType;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.WrappedOption;
import java.awt.Color;

class WrappedColor
implements WrappedOption {
    private static final String COLOR = "color";
    private Color color;

    WrappedColor(Color color) {
        this.color = color;
    }

    public WrappedColor() {
    }

    @Override
    public Object getObject() {
        return this.color;
    }

    @Override
    public void readState(SaveState saveState) {
        int rgb = saveState.getInt(COLOR, 0);
        this.color = new Color(rgb);
    }

    @Override
    public void writeState(SaveState saveState) {
        saveState.putInt(COLOR, this.color.getRGB());
    }

    @Override
    public OptionType getOptionType() {
        return OptionType.COLOR_TYPE;
    }
}

