/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* Generated by Together */

package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;

/**
 * The <CODE>VariableLocFieldLocation</CODE> class provides specific information
 * about the stack variable offset field within a program location.
 */

public class VariableLocFieldLocation extends VariableLocation {

	private String loc;

	/**
	 * Construct a new VariableLocFieldLocation object.
	 * @param program the program of the location
	 * @param locationAddr the address of the listing location (i.e., referent code unit)
	 * @param var the variable which has its location (stack offset) in the field.
	 * @param charOffset the position within the variable location (stack offset) string for this location.
	 */
	public VariableLocFieldLocation(Program program, Address locationAddr, Variable var,
			int charOffset) {

		super(program, locationAddr, var, 0, charOffset);
		loc = var.getVariableStorage().toString();
	}

	/**
	 * Construct a new VariableLocFieldLocation object.
	 * Variable function entry point is the assumed listing location (i.e., referent code unit).
	 * Care should be taken if variable corresponds to an EXTERNAL function.
	 * @param program the program of the location
	 * @param var the variable which has its location (stack offset) in the field.
	 * @param charOffset the position within the variable location (stack offset) string for this location.
	 */
	public VariableLocFieldLocation(Program program, Variable var, int charOffset) {

		super(program, var, 0, charOffset);
		loc = var.getVariableStorage().toString();
	}

	/**
	 * Should only be used by XML restoration.
	 */
	public VariableLocFieldLocation() {
		super();
	}

	/**
	 * Gets the location string. (For stack variables this is the offset as a string.)
	 */
	public String getLoc() {
		return loc;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((loc == null) ? 0 : loc.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		VariableLocFieldLocation other = (VariableLocFieldLocation) obj;
		if (loc == null) {
			if (other.loc != null)
				return false;
		}
		else if (!loc.equals(other.loc))
			return false;
		return true;
	}

	@Override
	public void restoreState(Program program1, SaveState obj) {
		super.restoreState(program1, obj);
		loc = obj.getString("_LOC", "");
	}

	@Override
	public void saveState(SaveState obj) {
		super.saveState(obj);
		obj.putString("_LOC", loc);
	}

}
