/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.janocchio;

import java.awt.Cursor;
import java.awt.Frame;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.jmol.dialog.Dialog;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.openscience.jmol.app.JmolApp;
import org.openscience.jmol.app.SplashInterface;
import org.openscience.jmol.app.janocchio.NMR_JmolPanel;
import org.openscience.jmol.app.janocchio.NmrGuiMap;
import org.openscience.jmol.app.janocchio.NmrPlugin;
import org.openscience.jmol.app.janocchio.NmrResourceHandler;
import org.openscience.jmol.app.jmolpanel.Splash;

public class Nmr
extends JmolApp {
    public static final String VERSION = "0.1.0";
    public static String path = Nmr.class.getName();
    private Splash splash;
    NmrPlugin plugin;
    JFrame mainFrame;
    NMR_JmolPanel nmrPanel;

    public boolean isPlugin() {
        return this.plugin != null;
    }

    public static void main(String[] args) {
        new Nmr(args);
    }

    public Nmr(String[] args, NmrPlugin plugin) {
        super(args);
        this.plugin = plugin;
        this.init();
    }

    public Nmr(String[] args) {
        super(args);
        this.init();
    }

    private void init() {
        try {
            if (this.haveDisplay) {
                Dialog.setupUIManager();
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (Exception exc) {
                    System.err.println("Error loading L&F: " + exc);
                }
            }
            this.mainFrame = new JFrame();
            if (this.jmolPosition != null) {
                this.mainFrame.setLocation(this.jmolPosition);
            }
            if (this.haveDisplay && this.splashEnabled) {
                ImageIcon splash_image = NmrResourceHandler.getIconX("splash");
                if (!this.isSilent) {
                    Logger.info("splash_image=" + splash_image);
                }
                this.splash = new Splash((Frame)this.mainFrame, splash_image);
                this.splash.setCursor(new Cursor(3));
                this.splash.showStatus(GT.$("Creating main window..."));
                this.splash.showStatus(GT.$("Initializing Swing..."));
            }
            this.info.put("guimap", new NmrGuiMap());
            if (this.splash != null) {
                this.splash.showStatus(GT.$("Initializing Jmol..."));
            }
            this.nmrPanel = new NMR_JmolPanel(this, this.splash, this.mainFrame, null, this.startupWidth, this.startupHeight, this.info, null);
            if (this.haveDisplay) {
                this.mainFrame.setVisible(true);
            }
            this.startViewer(this.nmrPanel.vwr, (SplashInterface)this.splash, false);
            if (this.haveConsole) {
                this.nmrPanel.getJavaConsole();
            }
            this.nmrPanel.vwr.script("set measureAllmodels ON;font measurements 18; font labels 18;measure '2:%1.1VALUE %UNITS//hz'");
        }
        catch (Throwable t) {
            Logger.error("uncaught exception: " + t);
            t.printStackTrace();
        }
    }

    static {
        path = path.substring(0, path.lastIndexOf(".") + 1);
    }
}

