/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.authentication.standard;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.socket.Reader;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.export.SslMode;
import org.mariadb.jdbc.message.client.AuthMoreRawPacket;
import org.mariadb.jdbc.message.server.AuthSwitchPacket;
import org.mariadb.jdbc.plugin.AuthenticationPlugin;

public class CachingSha2PasswordPlugin
implements AuthenticationPlugin {
    public static final String TYPE = "caching_sha2_password";
    private String authenticationData;
    private byte[] seed;
    private Configuration conf;
    private HostAddress hostAddress;

    public static byte[] sha256encryptPassword(CharSequence password, byte[] seed) {
        if (password == null) {
            return new byte[0];
        }
        byte[] truncatedSeed = AuthSwitchPacket.getTruncatedSeed(seed);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] bytePwd = password.toString().getBytes(StandardCharsets.UTF_8);
            byte[] stage1 = messageDigest.digest(bytePwd);
            messageDigest.reset();
            byte[] stage2 = messageDigest.digest(stage1);
            messageDigest.reset();
            messageDigest.update(stage2);
            messageDigest.update(truncatedSeed);
            byte[] digest = messageDigest.digest();
            byte[] returnBytes = new byte[digest.length];
            for (int i = 0; i < digest.length; ++i) {
                returnBytes[i] = (byte)(stage1[i] ^ digest[i]);
            }
            return returnBytes;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not use SHA-256, failing", e);
        }
    }

    public static PublicKey readPublicKeyFromFile(String serverRsaPublicKeyFile) throws SQLException {
        byte[] keyBytes;
        try {
            keyBytes = Files.readAllBytes(Paths.get(serverRsaPublicKeyFile, new String[0]));
        }
        catch (IOException ex) {
            throw new SQLException("Could not read server RSA public key from file : serverRsaPublicKeyFile=" + serverRsaPublicKeyFile, "S1009", ex);
        }
        return CachingSha2PasswordPlugin.generatePublicKey(keyBytes);
    }

    public static PublicKey generatePublicKey(byte[] publicKeyBytes) throws SQLException {
        try {
            String publicKey = new String(publicKeyBytes, StandardCharsets.US_ASCII).replaceAll("(-+BEGIN PUBLIC KEY-+\\r?\\n|\\n?-+END PUBLIC KEY-+\\r?\\n?)", "");
            byte[] keyBytes = Base64.getMimeDecoder().decode(publicKey);
            X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePublic(spec);
        }
        catch (Exception ex) {
            throw new SQLException("Could read server RSA public key: " + ex.getMessage(), "S1009", ex);
        }
    }

    public static byte[] encrypt(PublicKey publicKey, String password, byte[] seed) throws SQLException {
        byte[] correctedSeed = Arrays.copyOfRange(seed, 0, seed.length - 1);
        byte[] bytePwd = password.getBytes(StandardCharsets.UTF_8);
        byte[] nullFinishedPwd = Arrays.copyOf(bytePwd, bytePwd.length + 1);
        byte[] xorBytes = new byte[nullFinishedPwd.length];
        int seedLength = correctedSeed.length;
        for (int i = 0; i < xorBytes.length; ++i) {
            xorBytes[i] = (byte)(nullFinishedPwd[i] ^ correctedSeed[i % seedLength]);
        }
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(1, publicKey);
            return cipher.doFinal(xorBytes);
        }
        catch (Exception ex) {
            throw new SQLException("Error encoding password with public key : " + ex.getMessage(), "S1009", ex);
        }
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public void initialize(String authenticationData, byte[] seed, Configuration conf, HostAddress hostAddress) {
        this.seed = seed;
        this.authenticationData = authenticationData;
        this.conf = conf;
        this.hostAddress = hostAddress;
    }

    @Override
    public ReadableByteBuf process(Writer out, Reader in, Context context) throws IOException, SQLException {
        byte[] fastCryptPwd = CachingSha2PasswordPlugin.sha256encryptPassword(this.authenticationData, this.seed);
        new AuthMoreRawPacket(fastCryptPwd).encode(out, context);
        ReadableByteBuf buf = in.readReusablePacket();
        switch (buf.getByte()) {
            case -1: 
            case 0: {
                return buf;
            }
        }
        byte[] authResult = new byte[buf.readIntLengthEncodedNotNull()];
        buf.readBytes(authResult);
        switch (authResult[0]) {
            case 3: {
                return in.readReusablePacket();
            }
            case 4: {
                SslMode sslMode;
                SslMode sslMode2 = sslMode = this.hostAddress.sslMode == null ? this.conf.sslMode() : this.hostAddress.sslMode;
                if (sslMode != SslMode.DISABLE) {
                    byte[] bytePwd = this.authenticationData.getBytes();
                    byte[] nullEndedValue = new byte[bytePwd.length + 1];
                    System.arraycopy(bytePwd, 0, nullEndedValue, 0, bytePwd.length);
                    new AuthMoreRawPacket(nullEndedValue).encode(out, context);
                    out.flush();
                } else {
                    PublicKey publicKey;
                    if (this.conf.serverRsaPublicKeyFile() != null) {
                        publicKey = this.conf.serverRsaPublicKeyFile().contains("BEGIN PUBLIC KEY") ? CachingSha2PasswordPlugin.generatePublicKey(this.conf.serverRsaPublicKeyFile().getBytes()) : CachingSha2PasswordPlugin.readPublicKeyFromFile(this.conf.serverRsaPublicKeyFile());
                    } else {
                        if (!this.conf.allowPublicKeyRetrieval()) {
                            throw new SQLException("RSA public key is not available client side (option serverRsaPublicKeyFile not set)", "S1009");
                        }
                        out.writeByte(2);
                        out.flush();
                        buf = in.readReusablePacket();
                        switch (buf.getByte(0)) {
                            case -2: 
                            case -1: {
                                return buf;
                            }
                        }
                        buf.skip();
                        byte[] authMoreData = new byte[buf.readableBytes()];
                        buf.readBytes(authMoreData);
                        publicKey = CachingSha2PasswordPlugin.generatePublicKey(authMoreData);
                    }
                    byte[] cipherBytes = CachingSha2PasswordPlugin.encrypt(publicKey, this.authenticationData, this.seed);
                    out.writeBytes(cipherBytes);
                    out.flush();
                }
                return in.readReusablePacket();
            }
        }
        throw new SQLException("Protocol exchange error. Expect login success or RSA login request message", "S1009");
    }
}

