/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.mcpserver;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.action.mcpserver.McpAsyncServerHolder;
import org.opensearch.ml.common.transport.mcpserver.requests.remove.MLMcpToolsRemoveNodeRequest;
import org.opensearch.ml.common.transport.mcpserver.requests.remove.MLMcpToolsRemoveNodesRequest;
import org.opensearch.ml.common.transport.mcpserver.responses.remove.MLMcpToolsRemoveNodeResponse;
import org.opensearch.ml.common.transport.mcpserver.responses.remove.MLMcpToolsRemoveNodesResponse;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TransportMcpToolsRemoveOnNodesAction
extends TransportNodesAction<MLMcpToolsRemoveNodesRequest, MLMcpToolsRemoveNodesResponse, MLMcpToolsRemoveNodeRequest, MLMcpToolsRemoveNodeResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportMcpToolsRemoveOnNodesAction.class);
    TransportService transportService;
    ClusterService clusterService;
    ThreadPool threadPool;
    Client client;
    NamedXContentRegistry xContentRegistry;

    @Inject
    public TransportMcpToolsRemoveOnNodesAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/opensearch/ml/mcp_tools/remove_on_nodes", threadPool, clusterService, transportService, actionFilters, MLMcpToolsRemoveNodesRequest::new, MLMcpToolsRemoveNodeRequest::new, "management", MLMcpToolsRemoveNodeResponse.class);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    protected MLMcpToolsRemoveNodesResponse newResponse(MLMcpToolsRemoveNodesRequest nodesRequest, List<MLMcpToolsRemoveNodeResponse> responses, List<FailedNodeException> failures) {
        return new MLMcpToolsRemoveNodesResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected MLMcpToolsRemoveNodeRequest newNodeRequest(MLMcpToolsRemoveNodesRequest request) {
        return new MLMcpToolsRemoveNodeRequest(request.getMcpTools());
    }

    protected MLMcpToolsRemoveNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new MLMcpToolsRemoveNodeResponse(in);
    }

    protected MLMcpToolsRemoveNodeResponse nodeOperation(MLMcpToolsRemoveNodeRequest request) {
        return this.removeMcpTools(request.getMcpTools());
    }

    private MLMcpToolsRemoveNodeResponse removeMcpTools(List<String> tools) {
        AtomicReference errors = new AtomicReference();
        errors.set(new HashSet());
        Flux.fromStream(tools.stream()).flatMap(toolName -> {
            if (McpAsyncServerHolder.IN_MEMORY_MCP_TOOLS.containsKey(toolName)) {
                McpAsyncServerHolder.getMcpAsyncServerInstance().removeTool(toolName).onErrorResume(e -> {
                    log.error("Failed to remove mcp tool on node: {} with error: {}", (Object)this.clusterService.localNode().getId(), (Object)e.getMessage(), e);
                    ((Set)errors.get()).add(toolName);
                    return Mono.empty();
                }).doOnSuccess(x -> McpAsyncServerHolder.IN_MEMORY_MCP_TOOLS.remove(toolName)).subscribe();
            }
            return Mono.empty();
        }).doOnComplete(() -> log.debug("Successfully removed tools on node: {}", (Object)this.clusterService.localNode().getId())).subscribe();
        if (!((Set)errors.get()).isEmpty()) {
            String errMsg = String.format(Locale.ROOT, "Tools: %s not found on node: %s", errors.get(), this.clusterService.localNode().getId());
            OpenSearchException openSearchException = new OpenSearchException(errMsg, new Object[0]);
            throw new FailedNodeException(this.clusterService.localNode().getId(), openSearchException.getMessage(), (Throwable)openSearchException);
        }
        return new MLMcpToolsRemoveNodeResponse(this.clusterService.localNode(), Boolean.valueOf(true));
    }
}

