/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.obofoundry;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.obofoundry.OboFoundryRegistry;
import org.protege.editor.owl.model.obofoundry.OboFoundryRegistryParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OboFoundryRegistryManager {
    private static final Logger logger = LoggerFactory.getLogger(OboFoundryRegistryManager.class);
    private static OboFoundryRegistry registry = null;

    private static OboFoundryRegistry parse() {
        try {
            return OboFoundryRegistryParser.parseRegistryFromStandardLocation();
        }
        catch (IOException e) {
            try {
                logger.info("Could not parse OBO Foundry registry from {}.  Reason: {}", (Object)OboFoundryRegistryParser.getStandardRegistryLocation(), (Object)e.getMessage());
                return OboFoundryRegistryParser.parseRegistryFromLocalCopy();
            }
            catch (IOException e1) {
                logger.info("Could not parse OBO Foundry registry from local copy.  Reason: {}", (Object)OboFoundryRegistryParser.getStandardRegistryLocation(), (Object)e.getMessage());
                return OboFoundryRegistry.empty();
            }
        }
    }

    @Nonnull
    public static synchronized OboFoundryRegistry getRegistry() {
        if (registry == null) {
            registry = OboFoundryRegistryManager.parse();
        }
        return registry;
    }
}

