/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import com.google.common.base.Preconditions;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.prefix.PrefixedNameRenderer;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.protege.editor.owl.ui.renderer.OWLSystemColors;
import org.protege.editor.owl.ui.renderer.RenderingEscapeUtils;
import org.protege.editor.owl.ui.tree.OWLModelManagerTree;
import org.protege.editor.owl.ui.tree.OWLObjectTreeNode;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.OWLObjectVisitorExAdapter;

public class ProtegeTreeNodeRenderer
implements TreeCellRenderer {
    private static final Color UNSAT_ENTITY_COLOR = Color.RED;
    private static final Color DEPRECATED_CLASS_COLOR = Color.GRAY;
    private static final String EQUIV_SEPARATOR = " \u2261 ";
    @Nonnull
    private final OWLEditorKit editorKit;
    @Nonnull
    private final ActiveOntologyVisitor activeOntologyVisitor;
    private final DefaultTreeCellRendererEx delegateTreeCellRenderer = new DefaultTreeCellRendererEx();
    private final IconDecorator icon = new IconDecorator();
    private Font plainFont = new Font("sans-serif", 0, 12);
    private Font boldFont = this.plainFont.deriveFont(1);
    private final PrefixedNameRenderer prefixedNameRenderer = PrefixedNameRenderer.builder().withOwlPrefixes().withWellKnownPrefixes().build();

    public ProtegeTreeNodeRenderer(@Nonnull OWLEditorKit editorKit) {
        this.editorKit = (OWLEditorKit)((Object)Preconditions.checkNotNull((Object)((Object)editorKit)));
        this.activeOntologyVisitor = new ActiveOntologyVisitor(editorKit.getOWLModelManager());
    }

    private void setupFonts() {
        Font sysFont = OWLRendererPreferences.getInstance().getFont();
        if (!this.plainFont.equals(sysFont)) {
            this.plainFont = sysFont;
            this.boldFont = this.plainFont.deriveFont(1);
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        OWLObjectTreeNode node;
        Object object;
        this.setupFonts();
        boolean consistent = true;
        boolean deprecated = false;
        boolean satisfiable = true;
        boolean active = false;
        Object rendering = "";
        this.icon.clearIcon();
        this.icon.clearRelationship();
        this.icon.setRelationshipsDisplayed(false);
        if (value instanceof OWLObjectTreeNode && (object = (node = (OWLObjectTreeNode)value).getOWLObject()) != null) {
            consistent = this.isConsistent();
            if (consistent) {
                satisfiable = this.isSatisfiable((OWLObject)object);
            }
            rendering = this.getNodeStringRendering(node);
            String equivsRendering = node.getEquivalentObjects().stream().map(this::getOwlObjectDisabmiguatedRendering).map(this::prefixWithEquivalentSymbol).collect(Collectors.joining());
            rendering = (String)rendering + equivsRendering;
            deprecated = this.isDeprecated((OWLObject)object);
            active = this.isActive((OWLObject)object);
            Icon entityIcon = this.editorKit.getOWLWorkspace().getOWLIconProvider().getIcon((OWLObject)object);
            this.icon.setIcon(entityIcon);
            node.getRelationship().ifPresent(this.icon::setRelationship);
            boolean displayRelationships = ProtegeTreeNodeRenderer.shouldDisplayRelationships(tree);
            this.icon.setRelationshipsDisplayed(displayRelationships && !object.isTopEntity());
        }
        this.delegateTreeCellRenderer.setDeprecated(deprecated);
        if (!consistent || !satisfiable) {
            this.delegateTreeCellRenderer.setTextNonSelectionColor(UNSAT_ENTITY_COLOR);
        } else if (deprecated) {
            this.delegateTreeCellRenderer.setTextNonSelectionColor(DEPRECATED_CLASS_COLOR);
        } else {
            this.delegateTreeCellRenderer.setTextNonSelectionColor(Color.BLACK);
        }
        JLabel renderingComponent = (JLabel)this.delegateTreeCellRenderer.getTreeCellRendererComponent(tree, rendering, selected, expanded, leaf, row, hasFocus);
        if (active) {
            renderingComponent.setFont(this.boldFont);
        } else {
            renderingComponent.setFont(this.plainFont);
        }
        this.icon.setDeprecated(deprecated);
        this.icon.rebuild();
        renderingComponent.setIcon(this.icon);
        renderingComponent.setVerticalTextPosition(0);
        renderingComponent.setVerticalAlignment(0);
        return renderingComponent;
    }

    private String prefixWithEquivalentSymbol(String equivRendering) {
        return EQUIV_SEPARATOR + equivRendering;
    }

    private String getNodeStringRendering(OWLObjectTreeNode<?> node) {
        Object object = node.getOWLObject();
        return this.getOwlObjectDisabmiguatedRendering((OWLObject)object);
    }

    private String getOwlObjectDisabmiguatedRendering(OWLObject object) {
        return this.editorKit.getOWLModelManager().getDisabmiguatedRendering(object, RenderingEscapeUtils.RenderingEscapeSetting.UNESCAPED_RENDERING);
    }

    private static boolean shouldDisplayRelationships(@Nonnull JTree tree) {
        return tree instanceof OWLModelManagerTree && !((OWLModelManagerTree)tree).getProvider().getDisplayedRelationships().isEmpty();
    }

    private boolean isDeprecated(@Nonnull OWLObject owlObject) {
        return this.editorKit.getOWLModelManager().isDeprecated(owlObject);
    }

    private boolean isConsistent() {
        return this.editorKit.getOWLModelManager().getOWLReasonerManager().getCurrentReasoner().isConsistent();
    }

    private boolean isSatisfiable(@Nonnull OWLObject owlObject) {
        return !(owlObject instanceof OWLClass) || this.editorKit.getOWLModelManager().getOWLReasonerManager().getCurrentReasoner().isSatisfiable((OWLClassExpression)((OWLClass)owlObject));
    }

    private boolean isActive(@Nonnull OWLObject owlObject) {
        return (Boolean)owlObject.accept((OWLObjectVisitorEx)this.activeOntologyVisitor);
    }

    private static class DefaultTreeCellRendererEx
    extends DefaultTreeCellRenderer {
        private boolean deprecated = false;

        private DefaultTreeCellRendererEx() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.deprecated) {
                int textOffset = this.getIcon().getIconWidth() + this.getIconTextGap();
                int y = (int)((double)this.getHeight() * 3.0 / 5.0);
                g.drawLine(textOffset, y, this.getWidth(), y);
            }
        }

        public void setDeprecated(boolean deprecated) {
            this.deprecated = deprecated;
        }
    }

    private static class IconDecorator
    implements Icon {
        private static final BasicStroke RELATIONSHIP_STROKE = new BasicStroke(1.5f);
        private static final Color UNSPECIFIED_RELATIONSHIP_COLOR = new Color(190, 190, 190);
        @Nullable
        private Icon icon = null;
        private int width = 0;
        private int height = 0;
        private boolean deprecated = false;
        private boolean relationshipsDisplayed = false;
        private Composite alpha = AlphaComposite.getInstance(3, 0.2f);
        @Nullable
        private Object relationship;

        private IconDecorator() {
        }

        public void setDeprecated(boolean deprecated) {
            this.deprecated = deprecated;
        }

        public void clearIcon() {
            this.icon = null;
        }

        public void setIcon(@Nonnull Icon icon) {
            this.icon = icon;
        }

        public void clearRelationship() {
            this.relationship = null;
        }

        public void setRelationship(Object relationship) {
            this.relationship = relationship;
        }

        public void setRelationshipsDisplayed(boolean relationshipsDisplayed) {
            this.relationshipsDisplayed = relationshipsDisplayed;
        }

        public void rebuild() {
            this.width = 0;
            this.height = 0;
            if (this.icon != null) {
                this.height = this.icon.getIconHeight();
                this.width = this.icon.getIconWidth();
            }
            if (this.relationshipsDisplayed) {
                this.width += 18;
            }
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.icon == null) {
                return;
            }
            int xOffset = 1 + x;
            Graphics2D g2 = (Graphics2D)g;
            Composite comp = g2.getComposite();
            if (this.deprecated) {
                g2.setComposite(this.alpha);
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.relationshipsDisplayed) {
                g2.setStroke(RELATIONSHIP_STROKE);
                if (this.relationship != null) {
                    g.setColor(OWLSystemColors.getOWLObjectPropertyColor());
                } else {
                    g.setColor(UNSPECIFIED_RELATIONSHIP_COLOR);
                }
                int lineY = y + this.height / 2;
                g.drawLine(xOffset + 5, lineY, xOffset + 14, lineY);
                g.drawLine(xOffset + 4, lineY, xOffset + 6, lineY - 2);
                g.drawLine(xOffset + 4, lineY, xOffset + 6, lineY + 2);
                xOffset += 16;
            }
            if (this.icon != null) {
                this.icon.paintIcon(c, g, xOffset, y);
            }
            g2.setComposite(comp);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    private static final class ActiveOntologyVisitor
    extends OWLObjectVisitorExAdapter<Boolean> {
        @Nonnull
        private final OWLModelManager modelManager;

        public ActiveOntologyVisitor(@Nonnull OWLModelManager modelManager) {
            super((Object)false);
            this.modelManager = modelManager;
        }

        public Boolean visit(OWLClass ce) {
            return !this.modelManager.getActiveOntology().getAxioms(ce, Imports.EXCLUDED).isEmpty() || !this.modelManager.getActiveOntology().getAnnotationAssertionAxioms((OWLAnnotationSubject)ce.getIRI()).isEmpty();
        }

        public Boolean visit(OWLDataProperty property) {
            return !this.modelManager.getActiveOntology().getAxioms(property, Imports.EXCLUDED).isEmpty() || !this.modelManager.getActiveOntology().getAnnotationAssertionAxioms((OWLAnnotationSubject)property.getIRI()).isEmpty();
        }

        public Boolean visit(OWLObjectProperty property) {
            return !this.modelManager.getActiveOntology().getAxioms((OWLObjectPropertyExpression)property, Imports.EXCLUDED).isEmpty() || !this.modelManager.getActiveOntology().getAnnotationAssertionAxioms((OWLAnnotationSubject)property.getIRI()).isEmpty();
        }

        public Boolean visit(OWLNamedIndividual individual) {
            return !this.modelManager.getActiveOntology().getAxioms((OWLIndividual)individual, Imports.EXCLUDED).isEmpty() || !this.modelManager.getActiveOntology().getAnnotationAssertionAxioms((OWLAnnotationSubject)individual.getIRI()).isEmpty();
        }

        public Boolean visit(OWLAnnotationProperty property) {
            return !this.modelManager.getActiveOntology().getAxioms(property, Imports.EXCLUDED).isEmpty() || !this.modelManager.getActiveOntology().getAnnotationAssertionAxioms((OWLAnnotationSubject)property.getIRI()).isEmpty();
        }
    }
}

