# This file has been autogenerated by the pywayland scanner

# Copyright © 2017 Collabora, Ltd.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlKeyboard
from ..wayland import WlPointer
from ..wayland import WlTouch
from .zwp_input_timestamps_v1 import ZwpInputTimestampsV1


class ZwpInputTimestampsManagerV1(Interface):
    """Context object for high-resolution input timestamps

    A global interface used for requesting high-resolution timestamps for input
    events.
    """

    name = "zwp_input_timestamps_manager_v1"
    version = 1


class ZwpInputTimestampsManagerV1Proxy(Proxy[ZwpInputTimestampsManagerV1]):
    interface = ZwpInputTimestampsManagerV1

    @ZwpInputTimestampsManagerV1.request()
    def destroy(self) -> None:
        """Destroy the input timestamps manager object

        Informs the server that the client will no longer be using this
        protocol object. Existing objects created by this object are not
        affected.
        """
        self._marshal(0)
        self._destroy()

    @ZwpInputTimestampsManagerV1.request(
        Argument(ArgumentType.NewId, interface=ZwpInputTimestampsV1),
        Argument(ArgumentType.Object, interface=WlKeyboard),
    )
    def get_keyboard_timestamps(self, keyboard: WlKeyboard) -> Proxy[ZwpInputTimestampsV1]:
        """Subscribe to high-resolution keyboard timestamp events

        Creates a new input timestamps object that represents a subscription to
        high-resolution timestamp events for all
        :class:`~pywayland.protocol.wayland.WlKeyboard` events that carry a
        timestamp.

        If the associated :class:`~pywayland.protocol.wayland.WlKeyboard`
        object is invalidated, either through client action (e.g. release) or
        server-side changes, the input timestamps object becomes inert and the
        client should destroy it by calling
        :func:`ZwpInputTimestampsV1.destroy()
        <pywayland.protocol.input_timestamps_unstable_v1.ZwpInputTimestampsV1.destroy>`.

        :param keyboard:
            the :class:`~pywayland.protocol.wayland.WlKeyboard` object for
            which to get timestamp events
        :type keyboard:
            :class:`~pywayland.protocol.wayland.WlKeyboard`
        :returns:
            :class:`~pywayland.protocol.input_timestamps_unstable_v1.ZwpInputTimestampsV1`
        """
        id = self._marshal_constructor(1, ZwpInputTimestampsV1, keyboard)
        return id

    @ZwpInputTimestampsManagerV1.request(
        Argument(ArgumentType.NewId, interface=ZwpInputTimestampsV1),
        Argument(ArgumentType.Object, interface=WlPointer),
    )
    def get_pointer_timestamps(self, pointer: WlPointer) -> Proxy[ZwpInputTimestampsV1]:
        """Subscribe to high-resolution pointer timestamp events

        Creates a new input timestamps object that represents a subscription to
        high-resolution timestamp events for all
        :class:`~pywayland.protocol.wayland.WlPointer` events that carry a
        timestamp.

        If the associated :class:`~pywayland.protocol.wayland.WlPointer` object
        is invalidated, either through client action (e.g. release) or server-
        side changes, the input timestamps object becomes inert and the client
        should destroy it by calling :func:`ZwpInputTimestampsV1.destroy()
        <pywayland.protocol.input_timestamps_unstable_v1.ZwpInputTimestampsV1.destroy>`.

        :param pointer:
            the :class:`~pywayland.protocol.wayland.WlPointer` object for which
            to get timestamp events
        :type pointer:
            :class:`~pywayland.protocol.wayland.WlPointer`
        :returns:
            :class:`~pywayland.protocol.input_timestamps_unstable_v1.ZwpInputTimestampsV1`
        """
        id = self._marshal_constructor(2, ZwpInputTimestampsV1, pointer)
        return id

    @ZwpInputTimestampsManagerV1.request(
        Argument(ArgumentType.NewId, interface=ZwpInputTimestampsV1),
        Argument(ArgumentType.Object, interface=WlTouch),
    )
    def get_touch_timestamps(self, touch: WlTouch) -> Proxy[ZwpInputTimestampsV1]:
        """Subscribe to high-resolution touch timestamp events

        Creates a new input timestamps object that represents a subscription to
        high-resolution timestamp events for all
        :class:`~pywayland.protocol.wayland.WlTouch` events that carry a
        timestamp.

        If the associated :class:`~pywayland.protocol.wayland.WlTouch` object
        becomes invalid, either through client action (e.g. release) or server-
        side changes, the input timestamps object becomes inert and the client
        should destroy it by calling :func:`ZwpInputTimestampsV1.destroy()
        <pywayland.protocol.input_timestamps_unstable_v1.ZwpInputTimestampsV1.destroy>`.

        :param touch:
            the :class:`~pywayland.protocol.wayland.WlTouch` object for which
            to get timestamp events
        :type touch:
            :class:`~pywayland.protocol.wayland.WlTouch`
        :returns:
            :class:`~pywayland.protocol.input_timestamps_unstable_v1.ZwpInputTimestampsV1`
        """
        id = self._marshal_constructor(3, ZwpInputTimestampsV1, touch)
        return id


class ZwpInputTimestampsManagerV1Resource(Resource):
    interface = ZwpInputTimestampsManagerV1


class ZwpInputTimestampsManagerV1Global(Global):
    interface = ZwpInputTimestampsManagerV1


ZwpInputTimestampsManagerV1._gen_c()
ZwpInputTimestampsManagerV1.proxy_class = ZwpInputTimestampsManagerV1Proxy
ZwpInputTimestampsManagerV1.resource_class = ZwpInputTimestampsManagerV1Resource
ZwpInputTimestampsManagerV1.global_class = ZwpInputTimestampsManagerV1Global
