# This file has been autogenerated by the pywayland scanner

# Copyright © 2021-2023 Andri Yngvason
# Copyright © 2024 Simon Ser
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from .ext_image_copy_capture_frame_v1 import ExtImageCopyCaptureFrameV1


class ExtImageCopyCaptureSessionV1(Interface):
    """Image copy capture session

    This object represents an active image copy capture session.

    After a capture session is created, buffer constraint events will be
    emitted from the compositor to tell the client which buffer types and
    formats are supported for reading from the session. The compositor may re-
    send buffer constraint events whenever they change.

    To advertise buffer constraints, the compositor must send in no particular
    order: zero or more shm_format and dmabuf_format events, zero or one
    dmabuf_device event, and exactly one buffer_size event. Then the compositor
    must send a done event.

    When the client has received all the buffer constraints, it can create a
    buffer accordingly, attach it to the capture session using the
    attach_buffer request, set the buffer damage using the damage_buffer
    request and then send the capture request.
    """

    name = "ext_image_copy_capture_session_v1"
    version = 1

    class error(enum.IntEnum):
        duplicate_frame = 1


class ExtImageCopyCaptureSessionV1Proxy(Proxy[ExtImageCopyCaptureSessionV1]):
    interface = ExtImageCopyCaptureSessionV1

    @ExtImageCopyCaptureSessionV1.request(
        Argument(ArgumentType.NewId, interface=ExtImageCopyCaptureFrameV1),
    )
    def create_frame(self) -> Proxy[ExtImageCopyCaptureFrameV1]:
        """Create a frame

        Create a capture frame for this session.

        At most one frame object can exist for a given session at any time. If
        a client sends a create_frame request before a previous frame object
        has been destroyed, the duplicate_frame protocol error is raised.

        :returns:
            :class:`~pywayland.protocol.ext_image_copy_capture_v1.ExtImageCopyCaptureFrameV1`
        """
        frame = self._marshal_constructor(0, ExtImageCopyCaptureFrameV1)
        return frame

    @ExtImageCopyCaptureSessionV1.request()
    def destroy(self) -> None:
        """Delete this object

        Destroys the session. This request can be sent at any time by the
        client.

        This request doesn't affect
        :class:`~pywayland.protocol.ext_image_copy_capture_v1.ExtImageCopyCaptureFrameV1`
        objects created by this object.
        """
        self._marshal(1)
        self._destroy()


class ExtImageCopyCaptureSessionV1Resource(Resource):
    interface = ExtImageCopyCaptureSessionV1

    @ExtImageCopyCaptureSessionV1.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def buffer_size(self, width: int, height: int) -> None:
        """Image capture source dimensions

        Provides the dimensions of the source image in buffer pixel
        coordinates.

        The client must attach buffers that match this size.

        :param width:
            buffer width
        :type width:
            `ArgumentType.Uint`
        :param height:
            buffer height
        :type height:
            `ArgumentType.Uint`
        """
        self._post_event(0, width, height)

    @ExtImageCopyCaptureSessionV1.event(
        Argument(ArgumentType.Uint),
    )
    def shm_format(self, format: int) -> None:
        """Shm buffer format

        Provides the format that must be used for shared-memory buffers.

        This event may be emitted multiple times, in which case the client may
        choose any given format.

        :param format:
            shm format
        :type format:
            `ArgumentType.Uint`
        """
        self._post_event(1, format)

    @ExtImageCopyCaptureSessionV1.event(
        Argument(ArgumentType.Array),
    )
    def dmabuf_device(self, device: list) -> None:
        """Dma-buf device

        This event advertises the device buffers must be allocated on for dma-
        buf buffers.

        In general the device is a DRM node. The DRM node type (primary vs.
        render) is unspecified. Clients must not rely on the compositor sending
        a particular node type. Clients cannot check two devices for equality
        by comparing the dev_t value.

        :param device:
            device dev_t value
        :type device:
            `ArgumentType.Array`
        """
        self._post_event(2, device)

    @ExtImageCopyCaptureSessionV1.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Array),
    )
    def dmabuf_format(self, format: int, modifiers: list) -> None:
        """Dma-buf format

        Provides the format that must be used for dma-buf buffers.

        The client may choose any of the modifiers advertised in the array of
        64-bit unsigned integers.

        This event may be emitted multiple times, in which case the client may
        choose any given format.

        :param format:
            drm format code
        :type format:
            `ArgumentType.Uint`
        :param modifiers:
            drm format modifiers
        :type modifiers:
            `ArgumentType.Array`
        """
        self._post_event(3, format, modifiers)

    @ExtImageCopyCaptureSessionV1.event()
    def done(self) -> None:
        """All constraints have been sent

        This event is sent once when all buffer constraint events have been
        sent.

        The compositor must always end a batch of buffer constraint events with
        this event, regardless of whether it sends the initial constraints or
        an update.
        """
        self._post_event(4)

    @ExtImageCopyCaptureSessionV1.event()
    def stopped(self) -> None:
        """Session is no longer available

        This event indicates that the capture session has stopped and is no
        longer available. This can happen in a number of cases, e.g. when the
        underlying source is destroyed, if the user decides to end the image
        capture, or if an unrecoverable runtime error has occurred.

        The client should destroy the session after receiving this event.
        """
        self._post_event(5)


class ExtImageCopyCaptureSessionV1Global(Global):
    interface = ExtImageCopyCaptureSessionV1


ExtImageCopyCaptureSessionV1._gen_c()
ExtImageCopyCaptureSessionV1.proxy_class = ExtImageCopyCaptureSessionV1Proxy
ExtImageCopyCaptureSessionV1.resource_class = ExtImageCopyCaptureSessionV1Resource
ExtImageCopyCaptureSessionV1.global_class = ExtImageCopyCaptureSessionV1Global
