/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.FilterIndexOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RateLimiter;

public final class RateLimitedIndexOutput
extends FilterIndexOutput {
    private final RateLimiter rateLimiter;
    private long bytesSinceLastPause;
    private long currentMinPauseCheckBytes;

    public RateLimitedIndexOutput(RateLimiter rateLimiter, IndexOutput out) {
        super("RateLimitedIndexOutput(" + out + ")", out.getName(), out);
        this.rateLimiter = rateLimiter;
        this.currentMinPauseCheckBytes = rateLimiter.getMinPauseCheckBytes();
    }

    @Override
    public void writeByte(byte b) throws IOException {
        ++this.bytesSinceLastPause;
        this.checkRate();
        this.out.writeByte(b);
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        this.bytesSinceLastPause += (long)length;
        this.checkRate();
        this.out.writeBytes(b, offset, length);
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.bytesSinceLastPause += 4L;
        this.checkRate();
        this.out.writeInt(i);
    }

    @Override
    public void writeShort(short i) throws IOException {
        this.bytesSinceLastPause += 2L;
        this.checkRate();
        this.out.writeShort(i);
    }

    @Override
    public void writeLong(long i) throws IOException {
        this.bytesSinceLastPause += 8L;
        this.checkRate();
        this.out.writeLong(i);
    }

    private void checkRate() throws IOException {
        if (this.bytesSinceLastPause > this.currentMinPauseCheckBytes) {
            this.rateLimiter.pause(this.bytesSinceLastPause);
            this.bytesSinceLastPause = 0L;
            this.currentMinPauseCheckBytes = this.rateLimiter.getMinPauseCheckBytes();
        }
    }
}

