/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics;

import com.codahale.metrics.MetricRegistry;
import java.io.Closeable;
import java.io.IOException;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.metrics.SolrMetricsContext;

public class SolrCoreMetricManager
implements Closeable {
    private final SolrCore core;
    private SolrMetricsContext solrMetricsContext;
    private SolrMetricManager metricManager;
    private String collectionName;
    private String shardName;
    private String replicaName;
    private String leaderRegistryName;
    private boolean cloudMode;

    public SolrCoreMetricManager(SolrCore core) {
        this.core = core;
        this.initCloudMode();
        this.metricManager = core.getCoreContainer().getMetricManager();
        String registryName = SolrCoreMetricManager.createRegistryName(this.cloudMode, this.collectionName, this.shardName, this.replicaName, core.getName());
        this.solrMetricsContext = new SolrMetricsContext(this.metricManager, registryName, core.getMetricTag());
        this.leaderRegistryName = SolrCoreMetricManager.createLeaderRegistryName(this.cloudMode, this.collectionName, this.shardName);
    }

    private void initCloudMode() {
        CloudDescriptor cd = this.core.getCoreDescriptor().getCloudDescriptor();
        if (cd != null) {
            this.cloudMode = true;
            this.collectionName = this.core.getCoreDescriptor().getCollectionName();
            this.shardName = cd.getShardId();
            String coreName = this.core.getName();
            this.replicaName = Utils.parseMetricsReplicaName((String)this.collectionName, (String)coreName);
            if (this.replicaName == null) {
                this.replicaName = cd.getCoreNodeName();
            }
        }
    }

    public void loadReporters() {
        CoreContainer coreContainer = this.core.getCoreContainer();
        NodeConfig nodeConfig = coreContainer.getConfig();
        PluginInfo[] pluginInfos = nodeConfig.getMetricsConfig().getMetricReporters();
        this.metricManager.loadReporters(pluginInfos, this.core.getResourceLoader(), coreContainer, this.core, this.solrMetricsContext.getTag(), SolrInfoBean.Group.core, this.solrMetricsContext.getRegistryName());
        if (this.cloudMode) {
            this.metricManager.loadShardReporters(pluginInfos, this.core);
        }
    }

    public void afterCoreRename() {
        assert (this.core.getCoreDescriptor().getCloudDescriptor() == null);
        String oldRegistryName = this.solrMetricsContext.getRegistryName();
        String oldLeaderRegistryName = this.leaderRegistryName;
        String newRegistryName = SolrCoreMetricManager.createRegistryName(this.cloudMode, this.collectionName, this.shardName, this.replicaName, this.core.getName());
        this.leaderRegistryName = SolrCoreMetricManager.createLeaderRegistryName(this.cloudMode, this.collectionName, this.shardName);
        if (oldRegistryName.equals(newRegistryName)) {
            return;
        }
        this.metricManager.closeReporters(oldRegistryName, this.solrMetricsContext.getTag());
        if (oldLeaderRegistryName != null) {
            this.metricManager.closeReporters(oldLeaderRegistryName, this.solrMetricsContext.getTag());
        }
        this.solrMetricsContext = new SolrMetricsContext(this.metricManager, newRegistryName, this.solrMetricsContext.getTag());
        this.loadReporters();
    }

    public void registerMetricProducer(String scope, SolrMetricProducer producer) {
        if (scope == null || producer == null) {
            throw new IllegalArgumentException("registerMetricProducer() called with illegal arguments: scope = " + scope + ", producer = " + String.valueOf(producer));
        }
        producer.initializeMetrics(this.solrMetricsContext, scope);
    }

    public MetricRegistry getRegistry() {
        if (this.solrMetricsContext != null) {
            return this.solrMetricsContext.getMetricRegistry();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.metricManager.closeReporters(this.solrMetricsContext.getRegistryName(), this.solrMetricsContext.getTag());
        if (this.getLeaderRegistryName() != null) {
            this.metricManager.closeReporters(this.getLeaderRegistryName(), this.solrMetricsContext.getTag());
        }
        this.metricManager.unregisterGauges(this.solrMetricsContext.getRegistryName(), this.solrMetricsContext.getTag());
    }

    public SolrMetricsContext getSolrMetricsContext() {
        return this.solrMetricsContext;
    }

    public SolrCore getCore() {
        return this.core;
    }

    public String getRegistryName() {
        return this.solrMetricsContext != null ? this.solrMetricsContext.getRegistryName() : null;
    }

    public String getLeaderRegistryName() {
        return this.leaderRegistryName;
    }

    public String getTag() {
        return this.solrMetricsContext.getTag();
    }

    public static String createRegistryName(boolean cloud, String collectionName, String shardName, String replicaName, String coreName) {
        if (cloud) {
            return SolrMetricManager.getRegistryName(SolrInfoBean.Group.core, collectionName, shardName, replicaName);
        }
        return SolrMetricManager.getRegistryName(SolrInfoBean.Group.core, coreName);
    }

    public static String createRegistryName(SolrCore aCore, String coreName) {
        CloudDescriptor cd = aCore.getCoreDescriptor().getCloudDescriptor();
        String replicaName = null;
        if (cd != null) {
            replicaName = Utils.parseMetricsReplicaName((String)cd.getCollectionName(), (String)coreName);
        }
        return SolrCoreMetricManager.createRegistryName(cd != null, cd != null ? cd.getCollectionName() : null, cd != null ? cd.getShardId() : null, replicaName, coreName);
    }

    public static String createLeaderRegistryName(boolean cloud, String collectionName, String shardName) {
        if (cloud) {
            return SolrMetricManager.getRegistryName(SolrInfoBean.Group.collection, collectionName, shardName, "leader");
        }
        return null;
    }
}

