/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.ReRankCollector;

public class TopDocsSlice
extends DocSlice {
    private final TopDocs topDocs;
    private final boolean hasScores;

    public TopDocsSlice(int offset, int len, TopDocs topDocs, long matches, boolean hasScores, float maxScore, TotalHits.Relation matchesRelation) {
        super(offset, len, null, null, matches, maxScore, matchesRelation);
        this.topDocs = topDocs;
        this.hasScores = hasScores;
        this.docLength = topDocs.scoreDocs.length;
    }

    @Override
    public TopDocsSlice subset(int offset, int len) {
        if (this.offset == offset && this.len == len) {
            return this;
        }
        int requestedEnd = offset + len;
        if (requestedEnd > this.docLength && this.matches > (long)this.docLength) {
            return null;
        }
        int realEndDoc = Math.min(requestedEnd, this.docLength);
        int realLen = Math.max(realEndDoc - offset, 0);
        if (this.offset == offset && this.len == realLen) {
            return this;
        }
        return new TopDocsSlice(offset, realLen, this.topDocs, this.matches, this.hasScores, this.maxScore, this.matchesRelation);
    }

    @Override
    public boolean hasScores() {
        return this.topDocs != null && this.hasScores;
    }

    @Override
    public DocIterator iterator() {
        boolean hasOriginalScore;
        boolean bl = hasOriginalScore = this.topDocs.scoreDocs.length > 0 && this.topDocs.scoreDocs[0] instanceof ReRankCollector.RescoreDoc;
        if (hasOriginalScore) {
            return new ReRankedTopDocsIterator();
        }
        return new TopDocsIterator();
    }

    class ReRankedTopDocsIterator
    extends TopDocsIterator {
        ReRankedTopDocsIterator() {
        }

        @Override
        public Float originalScore() {
            try {
                return Float.valueOf(((ReRankCollector.RescoreDoc)TopDocsSlice.this.topDocs.scoreDocs[this.pos - 1]).originalScore);
            }
            catch (ClassCastException e) {
                return null;
            }
        }
    }

    class TopDocsIterator
    implements DocIterator {
        int pos;
        final int end;

        TopDocsIterator() {
            this.pos = TopDocsSlice.this.offset;
            this.end = TopDocsSlice.this.offset + TopDocsSlice.this.len;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.end;
        }

        @Override
        public Integer next() {
            return this.nextDoc();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The remove  operation is not supported by this Iterator.");
        }

        @Override
        public int nextDoc() {
            return TopDocsSlice.this.topDocs.scoreDocs[this.pos++].doc;
        }

        @Override
        public float score() {
            return TopDocsSlice.this.topDocs.scoreDocs[this.pos - 1].score;
        }
    }
}

