/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicConnector;
import com.sun.media.CircularBuffer;
import com.sun.media.InputConnector;
import com.sun.media.OutputConnector;
import javax.media.Buffer;

public class BasicInputConnector
extends BasicConnector
implements InputConnector {
    protected OutputConnector outputConnector = null;
    private boolean reset = false;

    public OutputConnector getOutputConnector() {
        return this.outputConnector;
    }

    public void reset() {
        CircularBuffer circularBuffer = this.circularBuffer;
        synchronized (circularBuffer) {
            this.reset = true;
            super.reset();
            this.circularBuffer.notifyAll();
        }
    }

    public boolean isValidBufferAvailable() {
        return this.circularBuffer.canRead();
    }

    public Buffer getValidBuffer() {
        switch (this.protocol) {
            case 0: {
                CircularBuffer circularBuffer = this.circularBuffer;
                synchronized (circularBuffer) {
                    if (!this.isValidBufferAvailable() && this.reset) {
                        Buffer buffer = null;
                        return buffer;
                    }
                    this.reset = false;
                    Buffer buffer = this.circularBuffer.read();
                    return buffer;
                }
            }
            case 1: {
                CircularBuffer circularBuffer = this.circularBuffer;
                synchronized (circularBuffer) {
                    this.reset = false;
                    while (!this.reset && !this.isValidBufferAvailable()) {
                        try {
                            this.circularBuffer.wait();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.reset) {
                        Buffer buffer = null;
                        return buffer;
                    }
                    Buffer buffer = this.circularBuffer.read();
                    this.circularBuffer.notifyAll();
                    Buffer buffer2 = buffer;
                    return buffer2;
                }
            }
        }
        throw new RuntimeException();
    }

    public void setOutputConnector(OutputConnector outputConnector) {
        this.outputConnector = outputConnector;
    }

    public void readReport() {
        switch (this.protocol) {
            case 0: 
            case 1: {
                CircularBuffer circularBuffer = this.circularBuffer;
                synchronized (circularBuffer) {
                    if (this.reset) {
                        return;
                    }
                    this.circularBuffer.readReport();
                    this.circularBuffer.notifyAll();
                    return;
                }
            }
        }
        throw new RuntimeException();
    }
}

