﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/gamelift/GameLiftRequest.h>
#include <aws/gamelift/GameLift_EXPORTS.h>

#include <utility>

namespace Aws {
namespace GameLift {
namespace Model {

/**
 */
class GetGameSessionLogUrlRequest : public GameLiftRequest {
 public:
  AWS_GAMELIFT_API GetGameSessionLogUrlRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetGameSessionLogUrl"; }

  AWS_GAMELIFT_API Aws::String SerializePayload() const override;

  AWS_GAMELIFT_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>A unique identifier for the game session to get logs for. </p>
   */
  inline const Aws::String& GetGameSessionId() const { return m_gameSessionId; }
  inline bool GameSessionIdHasBeenSet() const { return m_gameSessionIdHasBeenSet; }
  template <typename GameSessionIdT = Aws::String>
  void SetGameSessionId(GameSessionIdT&& value) {
    m_gameSessionIdHasBeenSet = true;
    m_gameSessionId = std::forward<GameSessionIdT>(value);
  }
  template <typename GameSessionIdT = Aws::String>
  GetGameSessionLogUrlRequest& WithGameSessionId(GameSessionIdT&& value) {
    SetGameSessionId(std::forward<GameSessionIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_gameSessionId;
  bool m_gameSessionIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace GameLift
}  // namespace Aws
