/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.cmd.PointFlag;
import tim.prune.cmd.ShuffleAndCropCmd;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;

public class DeleteMarkedPointsFunction
extends GenericFunction {
    private boolean _splitSegments = false;
    private String _parentFunctionKey = null;

    public DeleteMarkedPointsFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.deletemarked";
    }

    public void setParentFunction(String string, boolean bl) {
        this._parentFunctionKey = string;
        this._splitSegments = bl;
    }

    @Override
    public void begin() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        TrackInfo trackInfo = this._app.getTrackInfo();
        int n = 0;
        while (n < trackInfo.getTrack().getNumPoints()) {
            if (trackInfo.isPointMarkedForDeletion(n)) {
                arrayList2.add(n);
                if (trackInfo.isPointMarkedForSegmentBreak(n) || this._splitSegments) {
                    arrayList3.add(n);
                }
            } else {
                arrayList.add(n);
            }
            ++n;
        }
        if (arrayList2.isEmpty()) {
            String string = this._parentFunctionKey == null ? this.getNameKey() : this._parentFunctionKey;
            this._app.showErrorMessage(string, "dialog.deletemarked.nonefound");
        } else {
            ShuffleAndCropCmd shuffleAndCropCmd = new ShuffleAndCropCmd(arrayList, arrayList2, this.makeSegmentFlags(trackInfo.getTrack(), arrayList2, arrayList3));
            this._app.execute(shuffleAndCropCmd);
        }
    }

    private List<PointFlag> makeSegmentFlags(Track track, List<Integer> list, List<Integer> list2) {
        ArrayList<PointFlag> arrayList = new ArrayList<PointFlag>();
        HashSet<Integer> hashSet = new HashSet<Integer>(list);
        HashSet<Integer> hashSet2 = new HashSet<Integer>(list2);
        int n = track.getNumPoints();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            DataPoint dataPoint = track.getPoint(n2);
            if (!dataPoint.isWaypoint()) {
                boolean bl2 = bl = bl || hashSet2.contains(n2);
                if (!hashSet.contains(n2) && bl) {
                    arrayList.add(new PointFlag(dataPoint, true));
                    bl = false;
                }
            }
            ++n2;
        }
        return arrayList;
    }
}

