/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.closure;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.psi.PsiElement;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.GrPsiUpdateIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.closure.ForToEachPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public final class ForToEachIntention
extends GrPsiUpdateIntention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new ForToEachPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull ActionContext context, @NotNull ModPsiUpdater updater) {
        String bodyText;
        GrForStatement parentStatement;
        GrForInClause clause;
        if (element == null) {
            ForToEachIntention.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ForToEachIntention.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            ForToEachIntention.$$$reportNull$$$0(2);
        }
        if ((clause = (GrForInClause)(parentStatement = (GrForStatement)element).getClause()) == null) {
            return;
        }
        GrVariable valueVariable = Objects.requireNonNull(clause).getDeclaredVariable();
        if (valueVariable == null) {
            return;
        }
        GrVariable indexVariable = clause.getIndexVariable();
        GrStatement body = parentStatement.getBody();
        if (body == null) {
            return;
        }
        if (body instanceof GrBlockStatement) {
            String text = body.getText();
            bodyText = text.substring(1, text.length() - 1);
        } else {
            bodyText = body.getText();
        }
        GrExpression collection = clause.getIteratedExpression();
        assert (collection != null);
        @NonNls String statement = "x." + ForToEachIntention.getMethodName(indexVariable) + "{" + valueVariable.getText() + ForToEachIntention.getIndexVariableText(indexVariable) + " -> " + bodyText + " }";
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(parentStatement.getProject());
        GrMethodCallExpression eachExpression = (GrMethodCallExpression)factory.createTopElementFromText(statement);
        ((GrReferenceExpression)eachExpression.getInvokedExpression()).getQualifierExpression().replaceWithExpression(collection, true);
        parentStatement.replaceWithStatement(eachExpression);
    }

    @Override
    @NotNull
    public String getText(@NotNull PsiElement element) {
        GrForStatement parentStatement;
        GrForInClause clause;
        if (element == null) {
            ForToEachIntention.$$$reportNull$$$0(3);
        }
        if (Objects.requireNonNull(clause = (GrForInClause)(parentStatement = (GrForStatement)element).getClause()).getIndexVariable() != null) {
            String string = GroovyIntentionsBundle.message("for.to.each.with.index.intention.name", new Object[0]);
            if (string == null) {
                ForToEachIntention.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = GroovyIntentionsBundle.message("for.to.each.intention.name", new Object[0]);
        if (string == null) {
            ForToEachIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static String getMethodName(@Nullable GrVariable indexVariable) {
        if (indexVariable == null) {
            return "each";
        }
        return "eachWithIndex";
    }

    private static String getIndexVariableText(@Nullable GrVariable indexVariable) {
        if (indexVariable == null) {
            return "";
        }
        return ", " + indexVariable.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/closure/ForToEachIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/closure/ForToEachIntention";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

