/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.util.LineSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandRuntime;
import org.jetbrains.idea.svn.commandLine.CommandRuntimeModule;
import org.jetbrains.idea.svn.commandLine.InteractiveCommandListener;
import org.jetbrains.idea.svn.commandLine.LineCommandAdapter;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public abstract class BaseTerminalModule
extends LineCommandAdapter
implements CommandRuntimeModule,
InteractiveCommandListener {
    private static final Logger LOG = Logger.getInstance(BaseTerminalModule.class);
    @NotNull
    protected final CommandRuntime myRuntime;
    @NotNull
    protected final CommandExecutor myExecutor;
    protected boolean mySkipOneLine;

    protected BaseTerminalModule(@NotNull CommandRuntime runtime, @NotNull CommandExecutor executor) {
        if (runtime == null) {
            BaseTerminalModule.$$$reportNull$$$0(0);
        }
        if (executor == null) {
            BaseTerminalModule.$$$reportNull$$$0(1);
        }
        this.myRuntime = runtime;
        this.myExecutor = executor;
    }

    @Override
    public void onStart(@NotNull Command command) {
        if (command == null) {
            BaseTerminalModule.$$$reportNull$$$0(2);
        }
    }

    @Override
    public boolean handlePrompt(String line, Key outputType) {
        boolean result = this.doHandlePrompt(line, outputType);
        if (!result && this.mySkipOneLine) {
            LOG.debug("Skipped " + String.valueOf(outputType) + " line: " + line);
            this.mySkipOneLine = false;
            result = true;
        }
        return result;
    }

    protected abstract boolean doHandlePrompt(String var1, Key var2);

    protected boolean sendData(@NotNull String data) {
        if (data == null) {
            BaseTerminalModule.$$$reportNull$$$0(3);
        }
        try {
            this.mySkipOneLine = true;
            this.myExecutor.write(data + LineSeparator.CRLF.getSeparatorString());
            return true;
        }
        catch (SvnBindException e) {
            LOG.info((Throwable)((Object)e));
            return false;
        }
    }

    protected void cancelAuthentication() {
        this.myExecutor.destroyProcess(SvnBundle.message("error.authentication.canceled.for.repository", this.myExecutor.getCommand().requireRepositoryUrl().toDecodedString()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtime";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/commandLine/BaseTerminalModule";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onStart";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "sendData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

