/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.BackDependencyIndex;
import org.jetbrains.jps.dependency.Externalizer;
import org.jetbrains.jps.dependency.Graph;
import org.jetbrains.jps.dependency.MapletFactory;
import org.jetbrains.jps.dependency.MultiMaplet;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.ReferenceID;
import org.jetbrains.jps.dependency.impl.NodeDependenciesIndex;
import org.jetbrains.jps.dependency.impl.PathSource;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.SubclassesIndex;
import org.jetbrains.jps.dependency.kotlin.TypealiasesIndex;
import org.jetbrains.jps.util.Iterators;

@ApiStatus.Internal
public abstract class GraphImpl
implements Graph {
    private final BackDependencyIndex myDependencyIndex;
    private final List<BackDependencyIndex> myIndices;
    protected final MultiMaplet<ReferenceID, NodeSource> myNodeToSourcesMap;
    protected final MultiMaplet<NodeSource, Node<?, ?>> mySourceToNodesMap;
    private final MapletFactory myContainerFactory;
    private final IndexFactory myIndexFactory;
    private static final Set<String> ourMandatoryIndexNames = Set.of("node-backward-dependencies", "direct-subclasses", "type-aliases");

    protected GraphImpl(@NotNull MapletFactory cFactory, IndexFactory indexFactory) {
        if (cFactory == null) {
            GraphImpl.$$$reportNull$$$0(0);
        }
        this.myIndices = new ArrayList<BackDependencyIndex>();
        this.myContainerFactory = cFactory;
        this.myIndexFactory = indexFactory;
        try {
            HashSet<String> registered = new HashSet<String>();
            for (BackDependencyIndex index : indexFactory.createIndices(cFactory)) {
                this.myIndices.add(index);
                registered.add(index.getName());
            }
            if (!registered.containsAll(ourMandatoryIndexNames)) {
                throw new RuntimeException("Dependency Graph must contain following mandatory indices: " + String.valueOf(ourMandatoryIndexNames) + "\n\tCurrent registered indices: " + String.valueOf(registered));
            }
            this.myDependencyIndex = (BackDependencyIndex)Iterators.find(this.myIndices, idx -> "node-backward-dependencies".equals(idx.getName()));
            Externalizer<NodeSource> srcExternalizer = Externalizer.forGraphElement(PathSource::new, NodeSource[]::new);
            this.myNodeToSourcesMap = cFactory.createSetMultiMaplet("node-sources-map", Externalizer.forGraphElement(JvmNodeReferenceID::new, JvmNodeReferenceID[]::new), srcExternalizer);
            this.mySourceToNodesMap = cFactory.createSetMultiMaplet("source-nodes-map", srcExternalizer, Externalizer.forAnyGraphElement(Node[]::new));
        }
        catch (RuntimeException e) {
            this.closeIgnoreErrors();
            throw e;
        }
    }

    protected final IndexFactory getIndexFactory() {
        return this.myIndexFactory;
    }

    @Override
    @NotNull
    public Iterable<ReferenceID> getDependingNodes(@NotNull ReferenceID id) {
        if (id == null) {
            GraphImpl.$$$reportNull$$$0(1);
        }
        Iterable<ReferenceID> iterable = this.myDependencyIndex.getDependencies(id);
        if (iterable == null) {
            GraphImpl.$$$reportNull$$$0(2);
        }
        return iterable;
    }

    @Override
    public final Iterable<BackDependencyIndex> getIndices() {
        return this.myIndices;
    }

    @Override
    @Nullable
    public final BackDependencyIndex getIndex(String name) {
        for (BackDependencyIndex index : this.myIndices) {
            if (!index.getName().equals(name)) continue;
            return index;
        }
        return null;
    }

    @Override
    public Iterable<NodeSource> getSources(@NotNull ReferenceID id) {
        if (id == null) {
            GraphImpl.$$$reportNull$$$0(3);
        }
        return this.myNodeToSourcesMap.get(id);
    }

    @Override
    public Iterable<ReferenceID> getRegisteredNodes() {
        return this.myNodeToSourcesMap.getKeys();
    }

    @Override
    public Iterable<NodeSource> getSources() {
        return this.mySourceToNodesMap.getKeys();
    }

    @Override
    public Iterable<Node<?, ?>> getNodes(@NotNull NodeSource source) {
        if (source == null) {
            GraphImpl.$$$reportNull$$$0(4);
        }
        return this.mySourceToNodesMap.get(source);
    }

    protected final void closeIgnoreErrors() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void close() throws IOException {
        if (this.myContainerFactory instanceof Closeable) {
            ((Closeable)((Object)this.myContainerFactory)).close();
        }
    }

    public void flush() throws IOException {
        if (this.myContainerFactory instanceof Flushable) {
            ((Flushable)((Object)this.myContainerFactory)).flush();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cFactory";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/dependency/impl/GraphImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/dependency/impl/GraphImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependingNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDependingNodes";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSources";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNodes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface IndexFactory {
        public Iterable<BackDependencyIndex> createIndices(@NotNull MapletFactory var1);

        public static IndexFactory mandatoryIndices() {
            return containerFactory -> List.of(new NodeDependenciesIndex(containerFactory), new SubclassesIndex(containerFactory), new TypealiasesIndex(containerFactory));
        }

        public static IndexFactory create(Function<MapletFactory, BackDependencyIndex> ... extIndices) {
            IndexFactory mandatory = IndexFactory.mandatoryIndices();
            return containerFactory -> Iterators.collect((Iterable)Iterators.map(Arrays.asList(extIndices), extIndex -> (BackDependencyIndex)extIndex.apply(containerFactory)), (Collection)((ArrayList)Iterators.collect(mandatory.createIndices(containerFactory), new ArrayList())));
        }
    }
}

