/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.protocol.MessageUtil;

public class BrokerRegistrationChangeRecordJsonConverter {
    public static BrokerRegistrationChangeRecord read(JsonNode _node, short _version) {
        BrokerRegistrationChangeRecord _object = new BrokerRegistrationChangeRecord();
        JsonNode _brokerIdNode = _node.get("brokerId");
        if (_brokerIdNode == null) {
            throw new RuntimeException("BrokerRegistrationChangeRecord: unable to locate field 'brokerId', which is mandatory in version " + _version);
        }
        _object.brokerId = MessageUtil.jsonNodeToInt((JsonNode)_brokerIdNode, (String)"BrokerRegistrationChangeRecord");
        JsonNode _brokerEpochNode = _node.get("brokerEpoch");
        if (_brokerEpochNode == null) {
            throw new RuntimeException("BrokerRegistrationChangeRecord: unable to locate field 'brokerEpoch', which is mandatory in version " + _version);
        }
        _object.brokerEpoch = MessageUtil.jsonNodeToLong((JsonNode)_brokerEpochNode, (String)"BrokerRegistrationChangeRecord");
        JsonNode _fencedNode = _node.get("fenced");
        _object.fenced = _fencedNode == null ? (byte)0 : MessageUtil.jsonNodeToByte((JsonNode)_fencedNode, (String)"BrokerRegistrationChangeRecord");
        JsonNode _inControlledShutdownNode = _node.get("inControlledShutdown");
        _object.inControlledShutdown = _inControlledShutdownNode == null ? (byte)0 : MessageUtil.jsonNodeToByte((JsonNode)_inControlledShutdownNode, (String)"BrokerRegistrationChangeRecord");
        JsonNode _logDirsNode = _node.get("logDirs");
        if (_logDirsNode == null) {
            _object.logDirs = new ArrayList<Uuid>(0);
        } else {
            if (!_logDirsNode.isArray()) {
                throw new RuntimeException("BrokerRegistrationChangeRecord expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<Uuid> _collection = new ArrayList<Uuid>(_logDirsNode.size());
            _object.logDirs = _collection;
            for (JsonNode _element : _logDirsNode) {
                if (!_element.isTextual()) {
                    throw new RuntimeException("BrokerRegistrationChangeRecord element expected a JSON string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _collection.add(Uuid.fromString((String)_element.asText()));
            }
        }
        return _object;
    }

    public static JsonNode write(BrokerRegistrationChangeRecord _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("brokerId", (JsonNode)new IntNode(_object.brokerId));
        _node.set("brokerEpoch", (JsonNode)new LongNode(_object.brokerEpoch));
        if (_object.fenced != 0) {
            _node.set("fenced", (JsonNode)new ShortNode((short)_object.fenced));
        }
        if (_version >= 1) {
            if (_object.inControlledShutdown != 0) {
                _node.set("inControlledShutdown", (JsonNode)new ShortNode((short)_object.inControlledShutdown));
            }
        } else if (_object.inControlledShutdown != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default inControlledShutdown at version " + _version);
        }
        if (_version >= 2) {
            if (!_object.logDirs.isEmpty()) {
                ArrayNode _logDirsArray = new ArrayNode(JsonNodeFactory.instance);
                for (Uuid _element : _object.logDirs) {
                    _logDirsArray.add((JsonNode)new TextNode(_element.toString()));
                }
                _node.set("logDirs", (JsonNode)_logDirsArray);
            }
        } else if (!_object.logDirs.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default logDirs at version " + _version);
        }
        return _node;
    }

    public static JsonNode write(BrokerRegistrationChangeRecord _object, short _version) {
        return BrokerRegistrationChangeRecordJsonConverter.write(_object, _version, true);
    }
}

