/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.windows;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class WindowsGraphicsUtilsPort {
    public static void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text, int textShiftOffset) {
        FontMetrics fm = JideSwingUtilities.getFontMetrics(b, g);
        int mnemIndex = b.getDisplayedMnemonicIndex();
        if (SystemInfo.isMnemonicHidden()) {
            mnemIndex = -1;
        }
        WindowsGraphicsUtilsPort.paintClassicText(b, g, textRect.x + textShiftOffset, textRect.y + fm.getAscent() + textShiftOffset, text, mnemIndex);
    }

    static void paintClassicText(AbstractButton b, Graphics g, int x, int y, String text, int mnemIndex) {
        ButtonModel model = b.getModel();
        Color color = b.getForeground();
        if (model.isEnabled()) {
            if (!(b instanceof JMenuItem && model.isArmed() || b instanceof JMenu && (model.isSelected() || model.isRollover()))) {
                g.setColor(b.getForeground());
            }
            JideSwingUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, x, y);
        } else {
            color = WindowsGraphicsUtilsPort.getDisabledTextColor(b);
            if (color == null) {
                color = UIManager.getColor("Button.shadow");
            }
            Color shadow = UIManager.getColor("Button.disabledShadow");
            if (model.isArmed()) {
                color = UIManager.getColor("Button.disabledForeground");
            } else {
                if (shadow == null) {
                    shadow = b.getBackground().darker();
                }
                g.setColor(shadow);
                JideSwingUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, x + 1, y + 1);
            }
            if (color == null) {
                color = b.getBackground().brighter();
            }
            g.setColor(color);
            JideSwingUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, x, y);
        }
    }

    private static Color getDisabledTextColor(AbstractButton b) {
        if (b instanceof JCheckBox) {
            return UIManager.getColor("CheckBox.disabledText");
        }
        if (b instanceof JRadioButton) {
            return UIManager.getColor("RadioButton.disabledText");
        }
        if (b instanceof JToggleButton) {
            return UIManager.getColor("ToggleButton.disabledText");
        }
        if (b instanceof JButton) {
            return UIManager.getColor("Button.disabledText");
        }
        return null;
    }
}

