/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.indices.GetTemplateResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class GetTemplateRequest
extends RequestBase
implements ToCopyableBuilder<Builder, GetTemplateRequest> {
    @Nullable
    private final Time clusterManagerTimeout;
    @Nullable
    private final Boolean flatSettings;
    @Nullable
    private final Boolean local;
    @Deprecated
    @Nullable
    private final Time masterTimeout;
    @Nonnull
    private final List<String> name;
    public static final Endpoint<GetTemplateRequest, GetTemplateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetTemplateRequest, GetTemplateResponse>(request -> "GET", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.name())) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_template";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_template/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.name), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetTemplateResponse._DESERIALIZER);

    private GetTemplateRequest(Builder builder) {
        super(builder);
        this.clusterManagerTimeout = builder.clusterManagerTimeout;
        this.flatSettings = builder.flatSettings;
        this.local = builder.local;
        this.masterTimeout = builder.masterTimeout;
        this.name = ApiTypeHelper.unmodifiable(builder.name);
    }

    public static GetTemplateRequest of(Function<Builder, ObjectBuilder<GetTemplateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time clusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    @Nullable
    public final Boolean flatSettings() {
        return this.flatSettings;
    }

    @Nullable
    public final Boolean local() {
        return this.local;
    }

    @Deprecated
    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nonnull
    public final List<String> name() {
        return this.name;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.clusterManagerTimeout != null) {
            params.put("cluster_manager_timeout", this.clusterManagerTimeout._toJsonString());
        }
        if (this.flatSettings != null) {
            params.put("flat_settings", String.valueOf(this.flatSettings));
        }
        if (this.local != null) {
            params.put("local", String.valueOf(this.local));
        }
        if (this.masterTimeout != null) {
            params.put("master_timeout", this.masterTimeout._toJsonString());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.clusterManagerTimeout);
        result = 31 * result + Objects.hashCode(this.flatSettings);
        result = 31 * result + Objects.hashCode(this.local);
        result = 31 * result + Objects.hashCode(this.masterTimeout);
        result = 31 * result + Objects.hashCode(this.name);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTemplateRequest other = (GetTemplateRequest)o;
        return Objects.equals(this.clusterManagerTimeout, other.clusterManagerTimeout) && Objects.equals(this.flatSettings, other.flatSettings) && Objects.equals(this.local, other.local) && Objects.equals(this.masterTimeout, other.masterTimeout) && Objects.equals(this.name, other.name);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, GetTemplateRequest> {
        @Nullable
        private Time clusterManagerTimeout;
        @Nullable
        private Boolean flatSettings;
        @Nullable
        private Boolean local;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private List<String> name;

        public Builder() {
        }

        private Builder(GetTemplateRequest o) {
            super(o);
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.flatSettings = o.flatSettings;
            this.local = o.local;
            this.masterTimeout = o.masterTimeout;
            this.name = Builder._listCopy(o.name);
        }

        private Builder(Builder o) {
            super(o);
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.flatSettings = o.flatSettings;
            this.local = o.local;
            this.masterTimeout = o.masterTimeout;
            this.name = Builder._listCopy(o.name);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(@Nullable Time value) {
            this.clusterManagerTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.clusterManagerTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder flatSettings(@Nullable Boolean value) {
            this.flatSettings = value;
            return this;
        }

        @Nonnull
        public final Builder local(@Nullable Boolean value) {
            this.local = value;
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder name(List<String> list) {
            this.name = Builder._listAddAll(this.name, list);
            return this;
        }

        @Nonnull
        public final Builder name(String value, String ... values) {
            this.name = Builder._listAdd(this.name, value, values);
            return this;
        }

        @Override
        @Nonnull
        public GetTemplateRequest build() {
            this._checkSingleUse();
            return new GetTemplateRequest(this);
        }
    }
}

