/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.sps.metrics;

import java.util.HashSet;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.namenode.sps.ItemInfo;
import org.apache.hadoop.hdfs.server.namenode.sps.StoragePolicySatisfier;
import org.apache.hadoop.hdfs.server.sps.metrics.ExternalSPSMXBean;
import org.apache.hadoop.metrics2.util.MBeans;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalSPSBeanMetrics
implements ExternalSPSMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalSPSBeanMetrics.class);
    private ObjectName externalSPSBeanName;
    private StoragePolicySatisfier storagePolicySatisfier;

    public ExternalSPSBeanMetrics(StoragePolicySatisfier sps) {
        try {
            this.storagePolicySatisfier = sps;
            StandardMBean bean = new StandardMBean(this, ExternalSPSMXBean.class);
            this.externalSPSBeanName = MBeans.register((String)"ExternalSPS", (String)"ExternalSPS", (Object)bean);
            LOG.info("Registered ExternalSPS MBean: {}", (Object)this.externalSPSBeanName);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("Bad externalSPS MBean setup", e);
        }
    }

    public void close() {
        if (this.externalSPSBeanName != null) {
            MBeans.unregister((ObjectName)this.externalSPSBeanName);
            this.externalSPSBeanName = null;
        }
    }

    @Override
    public int getProcessingQueueSize() {
        return this.storagePolicySatisfier.processingQueueSize();
    }

    @VisibleForTesting
    public void updateProcessingQueueSize() {
        this.storagePolicySatisfier.getStorageMovementQueue().add(new ItemInfo(0L, 1L, 1));
    }

    @Override
    public int getMovementFinishedBlocksCount() {
        return this.storagePolicySatisfier.getAttemptedItemsMonitor().getMovementFinishedBlocksCount();
    }

    @VisibleForTesting
    public void updateMovementFinishedBlocksCount() {
        this.storagePolicySatisfier.getAttemptedItemsMonitor().getMovementFinishedBlocks().add(new Block(1L));
    }

    @Override
    public int getAttemptedItemsCount() {
        return this.storagePolicySatisfier.getAttemptedItemsMonitor().getAttemptedItemsCount();
    }

    @VisibleForTesting
    public void updateAttemptedItemsCount() {
        this.storagePolicySatisfier.getAttemptedItemsMonitor().getStorageMovementAttemptedItems().add(new StoragePolicySatisfier.AttemptedItemInfo(0L, 1L, 1L, new HashSet<Block>(), 1));
    }
}

