/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.net;

import com.google.common.base.Strings;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.net.URISupport;
import net.shibboleth.shared.primitive.StringSupport;

public class URLBuilder {
    @Nullable
    private String scheme;
    @Nullable
    private String username;
    @Nullable
    private String password;
    @Nullable
    private String host;
    @Nullable
    private Integer port;
    @Nullable
    private String path;
    @Nonnull
    private List<Pair<String, String>> queryParams;
    private String fragment;

    public URLBuilder() {
        this.queryParams = new ArrayList<Pair<String, String>>();
    }

    public URLBuilder(@Nonnull @NotEmpty String baseURL) throws MalformedURLException {
        URL url = new URL(baseURL);
        this.setScheme(url.getProtocol());
        String userInfo = url.getUserInfo();
        if (!Strings.isNullOrEmpty((String)userInfo)) {
            if (userInfo.contains(":")) {
                String[] userInfoComps = userInfo.split(":");
                this.setUsername(URISupport.doURLDecode(userInfoComps[0]));
                this.setPassword(URISupport.doURLDecode(userInfoComps[1]));
            } else {
                this.setUsername(userInfo);
            }
        }
        this.setHost(url.getHost());
        if (url.getPort() > 0) {
            this.setPort(url.getPort());
        }
        this.setPath(url.getPath());
        this.queryParams = new ArrayList<Pair<String, String>>();
        String queryString = url.getQuery();
        if (!Strings.isNullOrEmpty((String)queryString)) {
            String[] queryComps;
            for (String queryComp : queryComps = queryString.split("&")) {
                String paramValue;
                String paramName;
                int where = queryComp.indexOf(61);
                if (where < 0) {
                    paramName = URISupport.doURLDecode(queryComp);
                    this.queryParams.add(new Pair<String, Object>(paramName, null));
                    continue;
                }
                paramName = URISupport.doURLDecode(queryComp.substring(0, where));
                if ("".equals(paramName)) {
                    paramName = null;
                }
                if ("".equals(paramValue = URISupport.doURLDecode(queryComp.substring(where + 1)))) {
                    paramValue = null;
                }
                this.queryParams.add(new Pair<String, String>(paramName, paramValue));
            }
        }
        this.setFragment(url.getRef());
    }

    @Nullable
    public String getFragment() {
        return this.fragment;
    }

    public void setFragment(@Nullable String newFragment) {
        this.fragment = StringSupport.trimOrNull(newFragment);
    }

    @Nullable
    public String getHost() {
        return this.host;
    }

    public void setHost(@Nullable String newHost) {
        this.host = StringSupport.trimOrNull(newHost);
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public void setPassword(@Nullable String newPassword) {
        this.password = StringSupport.trimOrNull(newPassword);
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    public void setPath(@Nullable String newPath) {
        this.path = StringSupport.trimOrNull(newPath);
    }

    @Nullable
    public Integer getPort() {
        return this.port;
    }

    public void setPort(@Nullable Integer newPort) {
        this.port = newPort;
    }

    @Nonnull
    public List<Pair<String, String>> getQueryParams() {
        return this.queryParams;
    }

    @Nullable
    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(@Nullable String newScheme) {
        this.scheme = StringSupport.trimOrNull(newScheme);
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    public void setUsername(@Nullable String newUsername) {
        this.username = StringSupport.trimOrNull(newUsername);
    }

    @Nonnull
    public String buildURL() {
        String queryString;
        StringBuilder builder = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)this.scheme)) {
            builder.append(this.scheme);
            builder.append("://");
        }
        if (!Strings.isNullOrEmpty((String)this.username)) {
            builder.append(this.username);
            if (!Strings.isNullOrEmpty((String)this.password)) {
                builder.append(":");
                builder.append(this.password);
            }
            builder.append("@");
        }
        if (!Strings.isNullOrEmpty((String)this.host)) {
            builder.append(this.host);
            if (this.port != null && this.port > 0) {
                builder.append(":");
                builder.append(this.port);
            }
        }
        if (!Strings.isNullOrEmpty((String)this.path)) {
            if (this.path != null && !this.path.startsWith("/")) {
                builder.append("/");
            }
            builder.append(this.path);
        }
        if (!Strings.isNullOrEmpty((String)(queryString = this.buildQueryString()))) {
            builder.append("?");
            builder.append(queryString);
        }
        if (!Strings.isNullOrEmpty((String)this.fragment)) {
            builder.append("#");
            builder.append(this.fragment);
        }
        return builder.toString();
    }

    @Nullable
    public String buildQueryString() {
        if (this.queryParams.size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.queryParams.size(); ++i) {
                Pair<String, String> param = this.queryParams.get(i);
                String name = StringSupport.trimOrNull(param.getFirst());
                if (name == null) continue;
                builder.append(URISupport.doURLEncode(name));
                String value = StringSupport.trimOrNull(param.getSecond());
                if (value != null) {
                    builder.append("=");
                    builder.append(URISupport.doURLEncode(value));
                }
                if (i >= this.queryParams.size() - 1) continue;
                builder.append("&");
            }
            return builder.toString();
        }
        return null;
    }
}

