/*
 * Decompiled with CFR 0.152.
 */
package primitive.collection;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Random;

public class ByteList {
    private static final int DEFAULT = 1024;
    private static final double RESIZE = 1.8;
    private byte[] underlyingArray;
    private int pos;

    public ByteList() {
        this.clear();
    }

    public ByteList(int n) {
        this.underlyingArray = new byte[n];
    }

    public ByteList(byte[] byArray) {
        this.underlyingArray = byArray;
        this.pos = byArray.length;
    }

    public boolean add(byte by) {
        this.ensureCapacity(1);
        this.underlyingArray[this.pos++] = by;
        return true;
    }

    public void add(int n, byte by) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean addAll(ByteList byteList) {
        this.ensureCapacity(byteList.size());
        System.arraycopy(byteList.underlyingArray, 0, this.underlyingArray, this.size(), byteList.size());
        this.pos += byteList.size();
        return true;
    }

    public boolean addAll(byte[] byArray) {
        return this.addAll(byArray, 0, byArray.length);
    }

    public boolean addAll(byte[] byArray, int n, int n2) {
        this.ensureCapacity(n2);
        System.arraycopy(byArray, n, this.underlyingArray, this.size(), n2);
        this.pos += byArray.length;
        return true;
    }

    public boolean addAll(int n, ByteList byteList) {
        throw new UnsupportedOperationException("TBD");
    }

    public void clear() {
        if (null == this.underlyingArray || 1024 != this.underlyingArray.length) {
            this.underlyingArray = new byte[1024];
        }
        this.pos = 0;
    }

    public boolean contains(byte by) {
        return this.indexOf(by) != -1;
    }

    public boolean containsAll(ByteList byteList) {
        throw new UnsupportedOperationException("TBD");
    }

    public byte get(int n) {
        if (n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.underlyingArray[n];
    }

    public int indexOf(byte by) {
        for (int i = 0; i != this.size(); ++i) {
            if (by != this.underlyingArray[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(byte by) {
        for (int i = this.size() - 1; i != -1; --i) {
            if (by != this.underlyingArray[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return new Iterator(this);
    }

    public Iterator iterator(int n) {
        return new Iterator(this, n);
    }

    public boolean remove(byte by) {
        throw new UnsupportedOperationException("TBD");
    }

    public byte removeIdx(int n) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean removeAll(ByteList byteList) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean retainAll(ByteList byteList) {
        throw new UnsupportedOperationException("TBD");
    }

    public byte set(int n, byte by) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        byte by2 = this.get(n);
        this.underlyingArray[n] = by;
        return by2;
    }

    public int size() {
        return this.pos;
    }

    public ByteList subList(int n, int n2) {
        if (n < 0 || n2 > this.size() || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        byte[] byArray = new byte[n3];
        System.arraycopy(this.underlyingArray, n, byArray, 0, n3);
        return new ByteList(byArray);
    }

    public byte[] toArray() {
        byte[] byArray = new byte[this.pos];
        System.arraycopy(this.underlyingArray, 0, byArray, 0, this.pos);
        return byArray;
    }

    private void ensureCapacity(int n) {
        int n2 = this.underlyingArray.length - this.pos;
        if (n2 < n) {
            this.resize(this.underlyingArray.length + n);
        }
    }

    private void resize(int n) {
        int n2 = this.max(n, (int)((double)this.underlyingArray.length * 1.8));
        byte[] byArray = new byte[n2];
        System.arraycopy(this.underlyingArray, 0, byArray, 0, this.pos);
        this.underlyingArray = byArray;
    }

    private int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    private static void p(Object object) {
        System.out.println(object);
    }

    public static void main(String[] stringArray) {
        long l = System.currentTimeMillis();
        ByteList byteList = new ByteList();
        Random random = new Random(0L);
        byte[] byArray = new byte[1];
        for (int i = 0; i != 250000; ++i) {
            byte by = (byte)random.nextInt(256);
            byteList.add(by);
        }
        byte[] byArray2 = byteList.toArray();
        byteList.addAll(byArray2);
        ByteList.p("ok...: " + byteList.size() + " in: " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i != 250000; ++i) {
            int n = random.nextInt();
            arrayList.add(new Integer(n));
        }
        arrayList.addAll(arrayList);
        ByteList.p("ok...: " + arrayList.size() + " in: " + (System.currentTimeMillis() - l));
    }

    class Iterator {
        private ByteList list;
        private int pos;

        public Iterator(ByteList byteList2) {
            this.list = byteList2;
        }

        public Iterator(ByteList byteList2, int n) {
            if (n < 0 || n > byteList2.size()) {
                throw new IndexOutOfBoundsException();
            }
            this.list = byteList2;
            this.pos = n;
        }

        boolean hasNext() {
            return this.pos < this.list.size();
        }

        byte next() {
            if (this.pos >= this.list.size() || this.pos < 0) {
                throw new NoSuchElementException();
            }
            return this.list.get(this.pos++);
        }

        void remove() {
            throw new UnsupportedOperationException("TBD");
        }
    }
}

