/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.StatsField;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.handler.component.StatsValuesFactory;

class StatsInfo {
    private final ResponseBuilder rb;
    private final List<StatsField> statsFields = new ArrayList<StatsField>(7);
    private final Map<String, StatsValues> distribStatsValues = new LinkedHashMap<String, StatsValues>();
    private final Map<String, StatsField> statsFieldMap = new LinkedHashMap<String, StatsField>();
    private final Map<String, List<StatsField>> tagToStatsFields = new LinkedHashMap<String, List<StatsField>>();

    public StatsInfo(ResponseBuilder rb) {
        this.rb = rb;
        SolrParams params = rb.req.getParams();
        String[] statsParams = params.getParams("stats.field");
        if (null == statsParams) {
            return;
        }
        for (String paramValue : statsParams) {
            StatsField current = new StatsField(rb, paramValue);
            this.statsFields.add(current);
            for (String tag : current.getTagList()) {
                List<StatsField> fieldList = this.tagToStatsFields.get(tag);
                if (fieldList == null) {
                    fieldList = new ArrayList<StatsField>();
                }
                fieldList.add(current);
                this.tagToStatsFields.put(tag, fieldList);
            }
            this.statsFieldMap.put(current.getOutputKey(), current);
            this.distribStatsValues.put(current.getOutputKey(), StatsValuesFactory.createStatsValues(current));
        }
    }

    public List<StatsField> getStatsFields() {
        return Collections.unmodifiableList(this.statsFields);
    }

    public StatsField getStatsField(String outputKey) {
        return this.statsFieldMap.get(outputKey);
    }

    public List<StatsField> getStatsFieldsByTag(String tag) {
        List<StatsField> raw = this.tagToStatsFields.get(tag);
        if (null == raw) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(raw);
    }

    public Map<String, StatsValues> getAggregateStatsValues() {
        return Collections.unmodifiableMap(this.distribStatsValues);
    }
}

