#version 330

layout(std140) uniform passParams
{
    float passTime;
} _163;

uniform sampler2D atlasTexture;
uniform sampler2D atlasAlpha;
uniform sampler2D mask1Texture;
uniform sampler2D mask2Texture;

in vec2 vUV;
in vec4 maskUVs;
flat in uint vFlags;
layout(location = 0) out vec4 fragColor;
layout(location = 1) out vec4 lightColor;
in vec3 vTint;

float fetchMaskTexture(sampler2D mask1Texture_1, sampler2D mask2Texture_1, vec4 maskUVs_1, float time)
{
    float mask = 1.0;
    vec2 mask1UV = maskUVs_1.xy;
    vec2 mask2UV = maskUVs_1.zw;
    if (mask1UV.x > (-1.0))
    {
        mask = texture(mask1Texture_1, mask1UV).x;
        if (mask2UV.x > (-1.0))
        {
            mask *= texture(mask2Texture_1, mask2UV).x;
        }
        else
        {
            if (mask2UV.x <= (-2.0))
            {
                float timeScale = (-mask2UV.x) - 2.0;
                float wave = (sin((time * timeScale) + mask2UV.y) + 1.0) * 0.357142865657806396484375;
                mask = 1.0 - smoothstep(wave, wave + 0.300000011920928955078125, 1.0 - mask);
            }
        }
    }
    return mask;
}

vec4 YCoCgToRGB(vec4 ycocg, float alpha)
{
    float Y = ycocg.w;
    float scale = 1.0 / ((31.875 * ycocg.z) + 1.0);
    float Co = (ycocg.x - 0.501960813999176025390625) * scale;
    float Cg = (ycocg.y - 0.501960813999176025390625) * scale;
    float R = (Y + Co) - Cg;
    float G = Y + Cg;
    float B = (Y - Co) - Cg;
    return vec4(R, G, B, alpha);
}

void main()
{
    vec4 yCoCg = texture(atlasTexture, vUV);
    float alpha = texture(atlasAlpha, vUV).x;
    vec4 param = maskUVs;
    float param_1 = _163.passTime;
    float mask = fetchMaskTexture(mask1Texture, mask2Texture, param, param_1);
    vec4 param_2 = yCoCg;
    float param_3 = alpha;
    vec4 color = YCoCgToRGB(param_2, param_3) * mask;
    if ((vFlags & 4u) != 0u)
    {
        fragColor = vec4(0.0);
        lightColor = vec4(color.xyz, 0.0);
    }
    else
    {
        fragColor = color * vec4(vTint, 1.0);
        lightColor = vec4(0.0, 0.0, 0.0, color.w);
    }
}

