#version 330

layout(std140) uniform passParams
{
    float passTime;
} _97;

uniform sampler2D mask1Texture;
uniform sampler2D mask2Texture;
uniform sampler2D atlasTexture;

in vec4 maskUVs;
in vec2 vUV;
flat in uint vFlags;
layout(location = 0) out vec4 fragColor;
layout(location = 1) out vec4 lightColor;
in vec3 vTint;

float fetchMaskTexture(sampler2D mask1Texture_1, sampler2D mask2Texture_1, vec4 maskUVs_1, float time)
{
    float mask = 1.0;
    vec2 mask1UV = maskUVs_1.xy;
    vec2 mask2UV = maskUVs_1.zw;
    if (mask1UV.x > (-1.0))
    {
        mask = texture(mask1Texture_1, mask1UV).x;
        if (mask2UV.x > (-1.0))
        {
            mask *= texture(mask2Texture_1, mask2UV).x;
        }
        else
        {
            if (mask2UV.x <= (-2.0))
            {
                float timeScale = (-mask2UV.x) - 2.0;
                float wave = (sin((time * timeScale) + mask2UV.y) + 1.0) * 0.357142865657806396484375;
                mask = 1.0 - smoothstep(wave, wave + 0.300000011920928955078125, 1.0 - mask);
            }
        }
    }
    return mask;
}

void main()
{
    vec4 param = maskUVs;
    float param_1 = _97.passTime;
    float mask = fetchMaskTexture(mask1Texture, mask2Texture, param, param_1);
    vec4 color = texture(atlasTexture, vUV) * mask;
    if ((vFlags & 4u) != 0u)
    {
        fragColor = vec4(0.0);
        lightColor = vec4(color.xyz * (mask * mask), 0.0);
    }
    else
    {
        fragColor = color * vec4(vTint, 1.0);
        lightColor = vec4(0.0, 0.0, 0.0, color.w);
    }
}

