/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.WorldVersion;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.packs.VanillaAdvancementProvider;
import net.minecraft.data.advancements.packs.WinterDropAdvancementProvider;
import net.minecraft.data.info.BiomeParametersDumpReport;
import net.minecraft.data.info.BlockListReport;
import net.minecraft.data.info.CommandsReport;
import net.minecraft.data.info.DatapackStructureReport;
import net.minecraft.data.info.ItemListReport;
import net.minecraft.data.info.PacketReport;
import net.minecraft.data.info.RegistryDumpReport;
import net.minecraft.data.loot.packs.TradeRebalanceLootTableProvider;
import net.minecraft.data.loot.packs.VanillaLootTableProvider;
import net.minecraft.data.loot.packs.WinterDropLootTableProvider;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.data.models.EquipmentModelProvider;
import net.minecraft.data.models.ModelProvider;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.data.recipes.packs.WinterDropRecipeProvider;
import net.minecraft.data.registries.RegistriesDatapackGenerator;
import net.minecraft.data.registries.TradeRebalanceRegistries;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.registries.WinterDropRegistries;
import net.minecraft.data.structures.NbtToSnbt;
import net.minecraft.data.structures.SnbtToNbt;
import net.minecraft.data.structures.StructureUpdater;
import net.minecraft.data.tags.BannerPatternTagsProvider;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.CatVariantTagsProvider;
import net.minecraft.data.tags.DamageTypeTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.FlatLevelGeneratorPresetTagsProvider;
import net.minecraft.data.tags.FluidTagsProvider;
import net.minecraft.data.tags.GameEventTagsProvider;
import net.minecraft.data.tags.InstrumentTagsProvider;
import net.minecraft.data.tags.PaintingVariantTagsProvider;
import net.minecraft.data.tags.PoiTypeTagsProvider;
import net.minecraft.data.tags.StructureTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.data.tags.TradeRebalanceEnchantmentTagsProvider;
import net.minecraft.data.tags.TradeRebalanceStructureTagsProvider;
import net.minecraft.data.tags.VanillaBlockTagsProvider;
import net.minecraft.data.tags.VanillaEnchantmentTagsProvider;
import net.minecraft.data.tags.VanillaItemTagsProvider;
import net.minecraft.data.tags.WinterDropBiomeTagsProvider;
import net.minecraft.data.tags.WinterDropBlockTagsProvider;
import net.minecraft.data.tags.WinterDropEntityTypeTagsProvider;
import net.minecraft.data.tags.WinterDropItemTagsProvider;
import net.minecraft.data.tags.WorldPresetTagsProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;

public class Main {
    @DontObfuscate
    public static void main(String[] $$02) throws IOException {
        SharedConstants.tryDetectVersion();
        OptionParser $$1 = new OptionParser();
        AbstractOptionSpec $$2 = $$1.accepts("help", "Show the help menu").forHelp();
        OptionSpecBuilder $$3 = $$1.accepts("server", "Include server generators");
        OptionSpecBuilder $$4 = $$1.accepts("client", "Include client generators");
        OptionSpecBuilder $$5 = $$1.accepts("dev", "Include development tools");
        OptionSpecBuilder $$6 = $$1.accepts("reports", "Include data reports");
        OptionSpecBuilder $$7 = $$1.accepts("validate", "Validate inputs");
        OptionSpecBuilder $$8 = $$1.accepts("all", "Include all generators");
        ArgumentAcceptingOptionSpec $$9 = $$1.accepts("output", "Output folder").withRequiredArg().defaultsTo((Object)"generated", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$10 = $$1.accepts("input", "Input folder").withRequiredArg();
        OptionSet $$11 = $$1.parse($$02);
        if ($$11.has((OptionSpec)$$2) || !$$11.hasOptions()) {
            $$1.printHelpOn((OutputStream)System.out);
            return;
        }
        Path $$12 = Paths.get((String)$$9.value($$11), new String[0]);
        boolean $$13 = $$11.has((OptionSpec)$$8);
        boolean $$14 = $$13 || $$11.has((OptionSpec)$$4);
        boolean $$15 = $$13 || $$11.has((OptionSpec)$$3);
        boolean $$16 = $$13 || $$11.has((OptionSpec)$$5);
        boolean $$17 = $$13 || $$11.has((OptionSpec)$$6);
        boolean $$18 = $$13 || $$11.has((OptionSpec)$$7);
        DataGenerator $$19 = Main.createStandardGenerator($$12, $$11.valuesOf((OptionSpec)$$10).stream().map($$0 -> Paths.get($$0, new String[0])).collect(Collectors.toList()), $$14, $$15, $$16, $$17, $$18, SharedConstants.getCurrentVersion(), true);
        $$19.run();
    }

    private static <T extends DataProvider> DataProvider.Factory<T> bindRegistries(BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, T> $$0, CompletableFuture<HolderLookup.Provider> $$1) {
        return $$2 -> (DataProvider)$$0.apply($$2, $$1);
    }

    public static DataGenerator createStandardGenerator(Path $$02, Collection<Path> $$12, boolean $$22, boolean $$3, boolean $$4, boolean $$5, boolean $$6, WorldVersion $$7, boolean $$8) {
        DataGenerator $$9 = new DataGenerator($$02, $$7, $$8);
        DataGenerator.PackGenerator $$10 = $$9.getVanillaPack($$22 || $$3);
        $$10.addProvider($$1 -> new SnbtToNbt($$1, $$12).addFilter(new StructureUpdater()));
        CompletableFuture<HolderLookup.Provider> $$11 = CompletableFuture.supplyAsync(VanillaRegistries::createLookup, Util.backgroundExecutor());
        DataGenerator.PackGenerator $$122 = $$9.getVanillaPack($$22);
        $$122.addProvider(ModelProvider::new);
        $$122.addProvider(EquipmentModelProvider::new);
        DataGenerator.PackGenerator $$13 = $$9.getVanillaPack($$3);
        $$13.addProvider(Main.bindRegistries(RegistriesDatapackGenerator::new, $$11));
        $$13.addProvider(Main.bindRegistries(VanillaAdvancementProvider::create, $$11));
        $$13.addProvider(Main.bindRegistries(VanillaLootTableProvider::create, $$11));
        $$13.addProvider(Main.bindRegistries(VanillaRecipeProvider.Runner::new, $$11));
        TagsProvider $$14 = $$13.addProvider(Main.bindRegistries(VanillaBlockTagsProvider::new, $$11));
        TagsProvider $$15 = $$13.addProvider($$2 -> new VanillaItemTagsProvider($$2, $$11, $$14.contentsGetter()));
        TagsProvider $$16 = $$13.addProvider(Main.bindRegistries(BiomeTagsProvider::new, $$11));
        TagsProvider $$17 = $$13.addProvider(Main.bindRegistries(BannerPatternTagsProvider::new, $$11));
        TagsProvider $$18 = $$13.addProvider(Main.bindRegistries(StructureTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(CatVariantTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(DamageTypeTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(EntityTypeTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(FlatLevelGeneratorPresetTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(FluidTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(GameEventTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(InstrumentTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(PaintingVariantTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(PoiTypeTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(WorldPresetTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(VanillaEnchantmentTagsProvider::new, $$11));
        DataGenerator.PackGenerator $$19 = $$9.getVanillaPack($$4);
        $$19.addProvider($$1 -> new NbtToSnbt($$1, $$12));
        DataGenerator.PackGenerator $$20 = $$9.getVanillaPack($$5);
        $$20.addProvider(Main.bindRegistries(BiomeParametersDumpReport::new, $$11));
        $$20.addProvider(Main.bindRegistries(ItemListReport::new, $$11));
        $$20.addProvider(Main.bindRegistries(BlockListReport::new, $$11));
        $$20.addProvider(Main.bindRegistries(CommandsReport::new, $$11));
        $$20.addProvider(RegistryDumpReport::new);
        $$20.addProvider(PacketReport::new);
        $$20.addProvider(DatapackStructureReport::new);
        CompletableFuture<RegistrySetBuilder.PatchedRegistries> $$21 = TradeRebalanceRegistries.createLookup($$11);
        CompletionStage $$222 = $$21.thenApply(RegistrySetBuilder.PatchedRegistries::patches);
        DataGenerator.PackGenerator $$23 = $$9.getBuiltinDatapack($$3, "trade_rebalance");
        $$23.addProvider(Main.bindRegistries(RegistriesDatapackGenerator::new, (CompletableFuture<HolderLookup.Provider>)$$222));
        $$23.addProvider($$0 -> PackMetadataGenerator.forFeaturePack($$0, Component.translatable("dataPack.trade_rebalance.description"), FeatureFlagSet.of(FeatureFlags.TRADE_REBALANCE)));
        $$23.addProvider(Main.bindRegistries(TradeRebalanceLootTableProvider::create, $$11));
        $$23.addProvider(Main.bindRegistries(TradeRebalanceStructureTagsProvider::new, $$11));
        $$23.addProvider(Main.bindRegistries(TradeRebalanceEnchantmentTagsProvider::new, $$11));
        DataGenerator.PackGenerator $$24 = $$9.getBuiltinDatapack($$3, "redstone_experiments");
        $$24.addProvider($$0 -> PackMetadataGenerator.forFeaturePack($$0, Component.translatable("dataPack.redstone_experiments.description"), FeatureFlagSet.of(FeatureFlags.REDSTONE_EXPERIMENTS)));
        DataGenerator.PackGenerator $$25 = $$9.getBuiltinDatapack($$3, "minecart_improvements");
        $$25.addProvider($$0 -> PackMetadataGenerator.forFeaturePack($$0, Component.translatable("dataPack.minecart_improvements.description"), FeatureFlagSet.of(FeatureFlags.MINECART_IMPROVEMENTS)));
        CompletableFuture<RegistrySetBuilder.PatchedRegistries> $$26 = WinterDropRegistries.createLookup($$11);
        CompletionStage $$27 = $$26.thenApply(RegistrySetBuilder.PatchedRegistries::full);
        DataGenerator.PackGenerator $$28 = $$9.getBuiltinDatapack($$3, "winter_drop");
        $$28.addProvider(Main.bindRegistries(RegistriesDatapackGenerator::new, (CompletableFuture<HolderLookup.Provider>)$$26.thenApply(RegistrySetBuilder.PatchedRegistries::patches)));
        $$28.addProvider(Main.bindRegistries(WinterDropRecipeProvider.Runner::new, (CompletableFuture<HolderLookup.Provider>)$$27));
        TagsProvider $$29 = $$28.addProvider(arg_0 -> Main.lambda$createStandardGenerator$8((CompletableFuture)$$27, $$14, arg_0));
        $$28.addProvider(arg_0 -> Main.lambda$createStandardGenerator$9((CompletableFuture)$$27, $$15, $$29, arg_0));
        $$28.addProvider(arg_0 -> Main.lambda$createStandardGenerator$10((CompletableFuture)$$27, $$16, arg_0));
        $$28.addProvider(Main.bindRegistries(WinterDropLootTableProvider::create, (CompletableFuture<HolderLookup.Provider>)$$27));
        $$28.addProvider($$0 -> PackMetadataGenerator.forFeaturePack($$0, Component.translatable("dataPack.winter_drop.description"), FeatureFlagSet.of(FeatureFlags.WINTER_DROP)));
        $$28.addProvider(Main.bindRegistries(WinterDropEntityTypeTagsProvider::new, (CompletableFuture<HolderLookup.Provider>)$$27));
        $$28.addProvider(Main.bindRegistries(WinterDropAdvancementProvider::create, (CompletableFuture<HolderLookup.Provider>)$$27));
        return $$9;
    }

    private static /* synthetic */ WinterDropBiomeTagsProvider lambda$createStandardGenerator$10(CompletableFuture $$0, TagsProvider $$1, PackOutput $$2) {
        return new WinterDropBiomeTagsProvider($$2, $$0, $$1.contentsGetter());
    }

    private static /* synthetic */ WinterDropItemTagsProvider lambda$createStandardGenerator$9(CompletableFuture $$0, TagsProvider $$1, TagsProvider $$2, PackOutput $$3) {
        return new WinterDropItemTagsProvider($$3, $$0, $$1.contentsGetter(), $$2.contentsGetter());
    }

    private static /* synthetic */ WinterDropBlockTagsProvider lambda$createStandardGenerator$8(CompletableFuture $$0, TagsProvider $$1, PackOutput $$2) {
        return new WinterDropBlockTagsProvider($$2, $$0, $$1.contentsGetter());
    }
}

