/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;

public class DebugConfigCommand {
    public static void register(CommandDispatcher<CommandSourceStack> $$02) {
        $$02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("debugconfig").requires($$0 -> $$0.hasPermission(3))).then(Commands.literal("config").then(Commands.argument("target", EntityArgument.player()).executes($$0 -> DebugConfigCommand.config((CommandSourceStack)$$0.getSource(), EntityArgument.getPlayer((CommandContext<CommandSourceStack>)$$0, "target")))))).then(Commands.literal("unconfig").then(Commands.argument("target", UuidArgument.uuid()).suggests(($$0, $$1) -> SharedSuggestionProvider.suggest(DebugConfigCommand.getUuidsInConfig(((CommandSourceStack)$$0.getSource()).getServer()), $$1)).executes($$0 -> DebugConfigCommand.unconfig((CommandSourceStack)$$0.getSource(), UuidArgument.getUuid((CommandContext<CommandSourceStack>)$$0, "target"))))));
    }

    private static Iterable<String> getUuidsInConfig(MinecraftServer $$0) {
        HashSet<String> $$1 = new HashSet<String>();
        for (Connection $$2 : $$0.getConnection().getConnections()) {
            PacketListener packetListener = $$2.getPacketListener();
            if (!(packetListener instanceof ServerConfigurationPacketListenerImpl)) continue;
            ServerConfigurationPacketListenerImpl $$3 = (ServerConfigurationPacketListenerImpl)packetListener;
            $$1.add($$3.getOwner().getId().toString());
        }
        return $$1;
    }

    private static int config(CommandSourceStack $$0, ServerPlayer $$1) {
        GameProfile $$2 = $$1.getGameProfile();
        $$1.connection.switchToConfig();
        $$0.sendSuccess(() -> Component.literal("Switched player " + $$2.getName() + "(" + String.valueOf($$2.getId()) + ") to config mode"), false);
        return 1;
    }

    private static int unconfig(CommandSourceStack $$0, UUID $$1) {
        for (Connection $$2 : $$0.getServer().getConnection().getConnections()) {
            ServerConfigurationPacketListenerImpl $$3;
            PacketListener packetListener = $$2.getPacketListener();
            if (!(packetListener instanceof ServerConfigurationPacketListenerImpl) || !($$3 = (ServerConfigurationPacketListenerImpl)packetListener).getOwner().getId().equals($$1)) continue;
            $$3.returnToWorld();
        }
        $$0.sendFailure(Component.literal("Can't find player to unconfig"));
        return 0;
    }
}

